/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.init;

import com.bea.xml.XmlException;
import com.sun.java.xml.ns.j2Ee.ParamValueType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import weblogic.wsee.tools.wseegen.schemas.ConfigDocument;
import weblogic.wsee.tools.wseegen.schemas.ConfigType;
import weblogic.wsee.tools.wseegen.schemas.DeploymentListenersType;
import weblogic.wsee.tools.wseegen.schemas.ListenerType;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.init.WsConfig;
import weblogic.wsee.ws.init.WsDeploymentListenerConfig;

class WsConfigFactory {
    private static final String CONFIG_FILE_NAME = "wsee-config.xml";
    private static final String CONFIG_FILE_RESOURCE = "META-INF/wsee-config.xml";
    private static boolean VERBOSE = Verbose.isVerbose(WsConfigFactory.class);

    WsConfigFactory() {
    }

    WsConfig newInstance() {
        return this.newInstance(WsConfigFactory.findConfigFiles());
    }

    WsConfig newInstance(URL ... uRLArray) {
        WsConfig wsConfig = new WsConfig();
        for (URL uRL : uRLArray) {
            this.load(wsConfig, uRL);
        }
        return wsConfig;
    }

    private static URL[] findConfigFiles() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL uRL = WsConfigFactory.class.getResource(CONFIG_FILE_NAME);
        if (uRL == null) {
            throw new IllegalStateException("Cannot find standard configuration");
        }
        arrayList.add(uRL);
        ClassLoader classLoader = WsConfigFactory.class.getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(CONFIG_FILE_RESOURCE);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error attempting to load META-INF/wsee-config.xml");
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private void load(WsConfig wsConfig, URL uRL) {
        assert (uRL != null) : "No url specified";
        if (VERBOSE) {
            Verbose.log("Loading configuration from " + uRL + "...");
        }
        try {
            ConfigType configType = ConfigDocument.Factory.parse(uRL).getConfig();
            if (!configType.validate()) {
                throw new IllegalArgumentException("Configuration at " + uRL + " is invalid");
            }
            DeploymentListenersType deploymentListenersType = configType.getDeploymentListeners();
            if (deploymentListenersType != null) {
                if (deploymentListenersType.getClient() != null) {
                    for (ListenerType listenerType : deploymentListenersType.getClient().getListenerArray()) {
                        wsConfig.getDeploymentListeners().addClientListener(WsConfigFactory.getDeploymentListenerConfig(listenerType));
                    }
                }
                if (deploymentListenersType.getServer() != null) {
                    for (ListenerType listenerType : deploymentListenersType.getServer().getListenerArray()) {
                        wsConfig.getDeploymentListeners().addServerListener(WsConfigFactory.getDeploymentListenerConfig(listenerType));
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to process configuration at " + uRL, classNotFoundException);
        }
        catch (XmlException xmlException) {
            throw new IllegalArgumentException("Unable to process configuration at " + uRL, xmlException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to process configuration at " + uRL, iOException);
        }
    }

    private static WsDeploymentListenerConfig getDeploymentListenerConfig(ListenerType listenerType) throws ClassNotFoundException {
        if (VERBOSE) {
            Verbose.log("Loading deployment listener " + listenerType.getListenerClass().getStringValue() + "...");
        }
        Class clazz = ClassUtil.loadClass(listenerType.getListenerClass().getStringValue());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ParamValueType paramValueType : listenerType.getInitParamArray()) {
            hashMap.put(paramValueType.getParamName().getStringValue(), paramValueType.getParamValue().getStringValue());
        }
        WsDeploymentListenerConfig wsDeploymentListenerConfig = new WsDeploymentListenerConfig(clazz, hashMap);
        return wsDeploymentListenerConfig;
    }
}

