/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.init;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.init.WsConfigManager;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;
import weblogic.wsee.ws.init.WsDeploymentListenerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsDeploymentChain
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(WsDeploymentChain.class);
    private List<WsDeploymentListenerConfig> listenerList = new ArrayList<WsDeploymentListenerConfig>();

    private WsDeploymentChain(List<WsDeploymentListenerConfig> list, List<WsDeploymentListenerConfig> list2) {
        if (list2 != null) {
            this.listenerList.addAll(list2);
        }
        if (list != null) {
            this.listenerList.addAll(list);
        }
    }

    public static WsDeploymentListener newClientChain(List<WsDeploymentListenerConfig> list) {
        return new WsDeploymentChain(list, WsConfigManager.getInstance().getDeploymentListeners().getClientListeners());
    }

    public static WsDeploymentListener newServerChain(List<WsDeploymentListenerConfig> list) {
        return new WsDeploymentChain(list, WsConfigManager.getInstance().getDeploymentListeners().getServerListeners());
    }

    @Override
    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        for (WsDeploymentListener wsDeploymentListener : this.loadListeners()) {
            if (verbose) {
                Verbose.log("Processing WsDeploymentListener: " + wsDeploymentListener.getClass().getName());
            }
            wsDeploymentListener.process(wsDeploymentContext);
        }
    }

    private List<WsDeploymentListener> loadListeners() {
        ArrayList<WsDeploymentListener> arrayList = new ArrayList<WsDeploymentListener>(this.listenerList.size());
        for (WsDeploymentListenerConfig wsDeploymentListenerConfig : this.listenerList) {
            arrayList.add(wsDeploymentListenerConfig.newInstance());
        }
        return arrayList;
    }
}

