/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.ws.init;

import java.util.Collections;
import java.util.Map;
import weblogic.wsee.util.HashCodeBuilder;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.ws.init.Configurable;
import weblogic.wsee.ws.init.WsDeploymentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsDeploymentListenerConfig {
    private final Class deploymentListenerClass;
    private final Map<String, String> initParams;

    public WsDeploymentListenerConfig(Class clazz) {
        this(clazz, Collections.emptyMap());
    }

    public WsDeploymentListenerConfig(Class clazz, Map<String, String> map) {
        assert (clazz != null) : "no deployment listener class specified";
        assert (map != null) : "No initialization parameter.  Use other constructor";
        if (!map.isEmpty() && !Configurable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " cannot accept initialization parameters");
        }
        this.deploymentListenerClass = clazz;
        this.initParams = map;
    }

    WsDeploymentListener newInstance() {
        try {
            WsDeploymentListener wsDeploymentListener = (WsDeploymentListener)this.deploymentListenerClass.newInstance();
            if (wsDeploymentListener instanceof Configurable) {
                ((Configurable)((Object)wsDeploymentListener)).init(this.initParams);
            }
            return wsDeploymentListener;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unable to construct instance of " + this.deploymentListenerClass.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unable to construct instance of " + this.deploymentListenerClass.getName(), illegalAccessException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WsDeploymentListenerConfig)) {
            return false;
        }
        WsDeploymentListenerConfig wsDeploymentListenerConfig = (WsDeploymentListenerConfig)object;
        boolean bl = this.deploymentListenerClass == wsDeploymentListenerConfig.deploymentListenerClass;
        bl = bl && ObjectUtil.equals(this.initParams, wsDeploymentListenerConfig.initParams);
        return bl;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.add(this.deploymentListenerClass);
        hashCodeBuilder.add(this.initParams);
        return hashCodeBuilder.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.deploymentListenerClass.getName());
        if (this.initParams != null && !this.initParams.isEmpty()) {
            stringBuilder.append(this.initParams);
        }
        return stringBuilder.toString();
    }
}

