/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.wsdlc.WsdlcUtils;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.builder.WsdlBindingOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.internal.WsdlDefinitionsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Callback81WsdlExtracter {
    private static void saveUpdatedWsdl(WsdlDefinitionsImpl wsdlDefinitionsImpl, File file) throws WsBuildException, WsdlException {
        wsdlDefinitionsImpl.specialModeForCallback81Wsdl = true;
        try {
            wsdlDefinitionsImpl.writeToFile(file);
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
    }

    public static File extract(String string, String string2, File file) throws WsBuildException {
        try {
            WsdlDefinitions wsdlDefinitions = WsdlFactory.getInstance().parse(string);
            WsdlPort wsdlPort = null;
            wsdlPort = Callback81WsdlExtracter.extractWsdlPort(wsdlDefinitions, string2);
            assert (wsdlPort != null);
            Callback81WsdlExtracter.extractBinding(wsdlDefinitions, wsdlPort);
            Callback81WsdlExtracter.extractPortType(wsdlDefinitions, wsdlPort);
            Set<WsdlMessage> set = Callback81WsdlExtracter.extractOperations(wsdlPort);
            Callback81WsdlExtracter.extractBindingOperation(wsdlPort);
            Callback81WsdlExtracter.extractWsdlMessages(wsdlDefinitions, set);
            Callback81WsdlExtracter.updateServiceNameAndAddressInfo(wsdlDefinitions, wsdlPort);
            File file2 = new File(file, string2 + ".wsdl");
            Callback81WsdlExtracter.saveUpdatedWsdl((WsdlDefinitionsImpl)wsdlDefinitions, file2);
            return file2;
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException);
        }
    }

    private static void updateServiceNameAndAddressInfo(WsdlDefinitions wsdlDefinitions, WsdlPort wsdlPort) {
        WsdlServiceBuilder wsdlServiceBuilder = (WsdlServiceBuilder)wsdlDefinitions.getServices().values().iterator().next();
        wsdlServiceBuilder.setName(wsdlPort.getName());
        if ("jms".equalsIgnoreCase(wsdlPort.getBinding().getTransportProtocol())) {
            wsdlPort.getExtensions().remove("SOAP11-address");
            wsdlPort.getExtensions().remove("SOAP12-address");
        }
    }

    private static void extractWsdlMessages(WsdlDefinitions wsdlDefinitions, Set<WsdlMessage> set) {
        Iterator<? extends WsdlMessage> iterator = wsdlDefinitions.getMessages().values().iterator();
        while (iterator.hasNext()) {
            WsdlMessage wsdlMessage = iterator.next();
            if (set.contains(wsdlMessage)) continue;
            iterator.remove();
        }
    }

    private static void extractBindingOperation(WsdlPort wsdlPort) {
        Iterator<? extends WsdlBindingOperation> iterator = wsdlPort.getBinding().getOperations().values().iterator();
        while (iterator.hasNext()) {
            WsdlBindingOperationBuilder wsdlBindingOperationBuilder = (WsdlBindingOperationBuilder)iterator.next();
            if (wsdlPort.getBinding().getPortType().getOperations().get(wsdlBindingOperationBuilder.getName()) == null) {
                iterator.remove();
                continue;
            }
            wsdlBindingOperationBuilder.flipCallbackInputAndOutput();
            wsdlBindingOperationBuilder.getExtensions().remove("cwPhase");
        }
    }

    private static Set<WsdlMessage> extractOperations(WsdlPort wsdlPort) {
        Iterator<? extends WsdlOperation> iterator = wsdlPort.getBinding().getPortType().getOperations().values().iterator();
        HashSet<WsdlMessage> hashSet = new HashSet<WsdlMessage>();
        while (iterator.hasNext()) {
            WsdlOperationBuilder wsdlOperationBuilder = (WsdlOperationBuilder)iterator.next();
            if (!wsdlOperationBuilder.isWLW81CallbackOperation()) {
                iterator.remove();
                continue;
            }
            WsdlMessageBuilder wsdlMessageBuilder = wsdlOperationBuilder.getInput();
            WsdlMessageBuilder wsdlMessageBuilder2 = wsdlOperationBuilder.getOutput();
            if (wsdlMessageBuilder2 != null) {
                hashSet.add(wsdlMessageBuilder2);
            }
            if (wsdlMessageBuilder != null) {
                hashSet.add(wsdlMessageBuilder);
            }
            hashSet.addAll(wsdlOperationBuilder.getFaults().values());
            wsdlOperationBuilder.flipCallbackInputAndOutputParts();
        }
        return hashSet;
    }

    private static void extractPortType(WsdlDefinitions wsdlDefinitions, WsdlPort wsdlPort) {
        Iterator<? extends WsdlPortType> iterator = wsdlDefinitions.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            WsdlPortType wsdlPortType = iterator.next();
            if (wsdlPortType.equals(wsdlPort.getBinding().getPortType())) continue;
            iterator.remove();
        }
    }

    private static void extractBinding(WsdlDefinitions wsdlDefinitions, WsdlPort wsdlPort) {
        Iterator<? extends WsdlBinding> iterator = wsdlDefinitions.getBindings().values().iterator();
        while (iterator.hasNext()) {
            WsdlBinding wsdlBinding = iterator.next();
            if (wsdlBinding.equals(wsdlPort.getBinding())) continue;
            iterator.remove();
        }
    }

    private static WsdlPort extractWsdlPort(WsdlDefinitions wsdlDefinitions, String string) {
        WsdlPort wsdlPort = null;
        Iterator<? extends WsdlService> iterator = wsdlDefinitions.getServices().values().iterator();
        while (iterator.hasNext()) {
            WsdlService wsdlService = iterator.next();
            if (wsdlPort != null) {
                iterator.remove();
                break;
            }
            Iterator<? extends WsdlPort> iterator2 = wsdlService.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                WsdlPort wsdlPort2 = iterator2.next();
                if (WsdlcUtils.equalsNSOptional(QName.valueOf(string), wsdlPort2.getName())) {
                    wsdlPort = wsdlPort2;
                    continue;
                }
                iterator2.remove();
            }
        }
        return wsdlPort;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(Callback81WsdlExtracter.extract(stringArray[0], stringArray[1], new File(stringArray[2])).getCanonicalPath());
    }
}

