/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl;

import org.w3c.dom.Element;
import weblogic.wsee.addressing.wsdl.EndpointReferenceWsdlParser;
import weblogic.wsee.callback.wsdl.CallbackWsdlExtensionParser;
import weblogic.wsee.conversation.wsdl.ConversationWsdlExtensionParser;
import weblogic.wsee.policy.deployment.PolicyWsdlExtensionParser;
import weblogic.wsee.tools.jws.UpgradedJwsWsdlExtensionParser;
import weblogic.wsee.wsdl.UnknownExtensionParser;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.http.HttpExtensionParser;
import weblogic.wsee.wsdl.mime.MimeExtensionParser;
import weblogic.wsee.wsdl.soap11.SoapExtensionParser;
import weblogic.wsee.wsdl.soap12.Soap12ExtensionParser;

public final class WsdlExtensionRegistry
implements WsdlExtensionParser {
    private WsdlExtensionParser[] parsers = WsdlExtensionRegistry.createDefaultParsers();
    private static WsdlExtensionRegistry instance = new WsdlExtensionRegistry();

    private WsdlExtensionRegistry() {
    }

    public static WsdlExtensionParser getParser() {
        return instance;
    }

    private static WsdlExtensionParser[] createDefaultParsers() {
        WsdlExtensionParser[] wsdlExtensionParserArray = new WsdlExtensionParser[]{new SoapExtensionParser(), new Soap12ExtensionParser(), new ConversationWsdlExtensionParser(), new CallbackWsdlExtensionParser(), new UpgradedJwsWsdlExtensionParser(), new PolicyWsdlExtensionParser(), new MimeExtensionParser(), new HttpExtensionParser(), new EndpointReferenceWsdlParser(), new WsdlPartnerLinkType(), new UnknownExtensionParser()};
        return wsdlExtensionParserArray;
    }

    public WsdlExtension parseMessage(WsdlMessage wsdlMessage, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseMessage(wsdlMessage, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parseOperation(WsdlOperation wsdlOperation, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseOperation(wsdlOperation, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parseBinding(WsdlBinding wsdlBinding, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseBinding(wsdlBinding, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parseBindingOperation(WsdlBindingOperation wsdlBindingOperation, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseBindingOperation(wsdlBindingOperation, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parseBindingMessage(WsdlBindingMessage wsdlBindingMessage, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseBindingMessage(wsdlBindingMessage, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parseService(WsdlService wsdlService, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseService(wsdlService, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parsePort(WsdlPort wsdlPort, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parsePort(wsdlPort, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public WsdlExtension parseDefinitions(WsdlDefinitions wsdlDefinitions, Element element) throws WsdlException {
        for (int i = 0; i < this.parsers.length; ++i) {
            WsdlExtension wsdlExtension = this.parsers[i].parseDefinitions(wsdlDefinitions, element);
            if (wsdlExtension == null) continue;
            return wsdlExtension;
        }
        throw new WsdlException("Unable to parse extension " + element);
    }

    public void cleanUp() {
        for (int i = 0; i < this.parsers.length; ++i) {
            this.parsers[i].cleanUp();
        }
    }
}

