/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.util.dom.DOMParser;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;

public final class WsdlReader {
    private static final QName DEFAULT_NAMESPACE_ATTR = new QName("http://www.w3.org/2000/xmlns/", "xmlns");

    public static boolean isDocumentation(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        return "documentation".equals(node.getLocalName());
    }

    public static boolean isWhiteSpace(Node node) {
        String string;
        if (node.getNodeType() == 8) {
            return true;
        }
        return node.getNodeType() == 3 && ((string = node.getNodeValue()) == null || "".equals(string.trim()));
    }

    public static void checkWsdlNamespace(Element element) throws WsdlException {
        String string = element.getNamespaceURI();
        if (!WsdlConstants.wsdlNS.equals(string)) {
            throw new WsdlException("Found an element with unexpected namespace '" + string + "' . Was expecting '" + WsdlConstants.wsdlNS + "'");
        }
    }

    public static void checkWsdlDefinitions(String string, Element element) throws WsdlException {
        if (!string.equals(element.getLocalName())) {
            throw new WsdlException("The XML document specified is not a valid WSDL document. The name of the top level element should be '" + string + "' but found '" + element.getLocalName() + "'");
        }
    }

    public static void checkDomElement(Node node) throws WsdlException {
        if (node.getNodeType() != 1) {
            throw new WsdlException("Found an un expeced Node " + node.getNodeName() + " with name = " + node.getLocalName() + " and with text content = " + node.getTextContent());
        }
    }

    public static String getMustAttribute(Element element, String string, String string2) throws WsdlException {
        String string3 = WsdlReader.getAttribute(element, string, string2);
        if (string3 == null || "".equals(string3)) {
            throw new WsdlException("Must attribute '" + string2 + "' not" + "found in element '" + element.getLocalName());
        }
        return string3;
    }

    public static String getAttribute(Element element, String string, String string2, boolean bl) {
        String string3 = string == null ? element.getAttribute(string2) : element.getAttributeNS(string, string2);
        if (string3 == null) {
            return null;
        }
        if ("".equals(string3)) {
            if (bl) {
                return "";
            }
            return null;
        }
        return string3;
    }

    public static String getAttribute(Element element, String string, String string2) {
        return WsdlReader.getAttribute(element, string, string2, false);
    }

    public static QName createQName(Element element, String string) throws WsdlException {
        int n = string.indexOf(":");
        if (n == -1) {
            String string2 = WsdlReader.getDefaultNamespace(element);
            return string2 == null ? new QName(string) : new QName(string2, string);
        }
        String string3 = string.substring(0, n);
        String string4 = WsdlReader.getNamespace(string3, element);
        if (string4 == null) {
            throw new WsdlException("Unable to find namespace for prefix '" + string3 + "'. This is used in element " + element);
        }
        return new QName(string4, string.substring(n + 1, string.length()));
    }

    private static String getNamespace(String string, Element element) {
        Node node;
        String string2 = null;
        do {
            if ((string2 = element.getAttribute("xmlns:" + string)) == null || string2.equals("")) continue;
            return string2;
        } while ((element = (node = element.getParentNode()) instanceof Element ? (Element)node : null) != null);
        return null;
    }

    private static String getDefaultNamespace(Element element) {
        Node node;
        String string = null;
        do {
            if (!element.hasAttributeNS(DEFAULT_NAMESPACE_ATTR.getNamespaceURI(), DEFAULT_NAMESPACE_ATTR.getLocalPart())) continue;
            string = element.getAttributeNS(DEFAULT_NAMESPACE_ATTR.getNamespaceURI(), DEFAULT_NAMESPACE_ATTR.getLocalPart());
            if (string.length() == 0) {
                return null;
            }
            return string;
        } while ((element = (node = element.getParentNode()) instanceof Element ? (Element)node : null) != null);
        return null;
    }

    public static boolean tagEquals(Element element, String string, String string2) {
        if (!string.equals(element.getLocalName())) {
            return false;
        }
        if (string2 == null) {
            return element.getNamespaceURI() == null;
        }
        return string2.equals(element.getNamespaceURI());
    }

    public static Document getDocument(String string) throws WsdlException {
        return WsdlReader.getDocument(null, string);
    }

    public static Document getDocument(TransportInfo transportInfo, String string) throws WsdlException {
        try {
            return DOMParser.getDocument(transportInfo, string);
        }
        catch (IOException iOException) {
            throw new WsdlException("Failed to read wsdl file from url due to -- " + iOException, iOException);
        }
    }

    public static Document getDocument(InputSource inputSource) throws WsdlException {
        try {
            return DOMParser.getDocument(inputSource);
        }
        catch (IOException iOException) {
            throw new WsdlException("Failed to read wsdl file from InputSource due to -- " + iOException, iOException);
        }
    }
}

