/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.addressing.wsdl.EndpointReferenceWsdlExtension;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.wsdl.RelativeResourceResolver;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.internal.WsdlDefinitionsImpl;
import weblogic.wsee.wsdl.internal.WsdlTypesImpl;
import weblogic.wsee.wsdl.mime.MimeContent;
import weblogic.wsee.wsdl.mime.MimeMultipartRelated;
import weblogic.wsee.wsdl.mime.MimePart;
import weblogic.wsee.wsdl.soap11.SoapAddress;

public class WsdlUtils {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static WsdlDefinitions findWsdlDefinition(String string, WsdlDefinitions wsdlDefinitions) {
        if (string.length() < 4) {
            return null;
        }
        if (!"WSDL".equalsIgnoreCase(string.substring(0, 4))) {
            return null;
        }
        if (string.length() == 4) {
            return wsdlDefinitions;
        }
        String string2 = string.substring(5);
        return ((WsdlDefinitionsImpl)wsdlDefinitions).findImport(string2);
    }

    public static WsdlSchema findSchema(String string, WsdlDefinitionsImpl wsdlDefinitionsImpl) {
        if (string.length() < 4) {
            return null;
        }
        if (!"WSDL".equalsIgnoreCase(string.substring(0, 4))) {
            return null;
        }
        if (string.length() == 4) {
            throw new AssertionError((Object)("This is WSDL request. Should never get here with query.length==4 where query='" + string + "'"));
        }
        String string2 = string.substring(5);
        WsdlTypesImpl wsdlTypesImpl = (WsdlTypesImpl)wsdlDefinitionsImpl.getTypes();
        return wsdlTypesImpl == null ? null : wsdlTypesImpl.findImport(string2);
    }

    public static void updateAddress(WsdlDefinitions wsdlDefinitions, WsdlAddressInfo wsdlAddressInfo) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        String string = serverMBean.getListenAddress();
        if (string == null) {
            string = "localhost";
        }
        wsdlAddressInfo.setHost(string);
        wsdlAddressInfo.setPort("" + serverMBean.getListenPort());
        for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                Object object;
                SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
                String string2 = wsdlAddressInfo.getServiceUrl(wsdlPort.getName());
                if (soapAddress != null && string2 != null) {
                    object = WsdlUtils.getQueryString(wsdlPort);
                    if (object != null) {
                        string2 = string2 + "?" + (String)object;
                    }
                    soapAddress.setLocation(string2);
                }
                if ((object = WsdlUtils.getEndpointReferencelExtension(wsdlPort)) == null || string2 == null) continue;
                ((EndpointReferenceWsdlExtension)object).setAddressLocation(string2);
            }
        }
    }

    public static boolean policyExists(Map map, PolicyStatement policyStatement) {
        String string = policyStatement.getId();
        if (string == null) {
            return map.get(policyStatement) != null;
        }
        return map.get(string) != null;
    }

    public static void addPolicyToMap(Map map, PolicyStatement policyStatement) {
        String string = policyStatement.getId();
        if (string != null) {
            map.put(string, policyStatement);
            return;
        }
        map.put(policyStatement, policyStatement);
    }

    public static String findReturnPart(WsdlOperation wsdlOperation) {
        WsdlMessage wsdlMessage;
        Object object;
        String string = ((WsdlOperationBuilder)wsdlOperation).getParameterOrder();
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                hashSet.add(((StringTokenizer)object).nextToken());
            }
        }
        if (((WsdlOperationBuilder)wsdlOperation).isWLW81CallbackOperation()) {
            wsdlMessage = wsdlOperation.getOutput();
            object = wsdlOperation.getInput();
        } else {
            wsdlMessage = wsdlOperation.getInput();
            object = wsdlOperation.getOutput();
        }
        if (object == null) {
            return null;
        }
        String string2 = null;
        for (WsdlPart wsdlPart : object.getParts().values()) {
            WsdlPart wsdlPart2;
            WsdlPart wsdlPart3 = wsdlPart2 = wsdlMessage == null ? null : wsdlMessage.getParts().get(wsdlPart.getName());
            if (wsdlPart2 == null && hashSet.contains(wsdlPart.getName()) || wsdlPart.equals(wsdlPart2)) continue;
            if (string2 == null) {
                string2 = wsdlPart.getName();
                continue;
            }
            if (StringUtil.isEmpty(string)) {
                return null;
            }
            throw new IllegalStateException("While processing WSDL '" + wsdlOperation.getName().toString() + "' More than one return outPart found in " + "operation: " + wsdlOperation + ". Only one outPart name can be " + "missing in the parameterOrder");
        }
        return string2;
    }

    public static String getQueryString(WsdlPort wsdlPort) {
        SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
        String string = null;
        if (soapAddress != null) {
            String string2 = soapAddress.getLocation();
            try {
                URI uRI = new URI(string2);
                string = uRI.getQuery();
            }
            catch (URISyntaxException uRISyntaxException) {
                Verbose.log((Object)("Failed to create URI from WSDL location, where location='" + (string2 == null ? "NULL" : string2) + "'"), uRISyntaxException);
            }
        }
        return string;
    }

    public static String constructRelativeLocation(String string, String string2) throws WsdlException {
        return WsdlUtils.constructRelativeLocation(string, string2, null);
    }

    public static String constructRelativeLocation(String string, String string2, RelativeResourceResolver relativeResourceResolver) throws WsdlException {
        URL uRL;
        if (relativeResourceResolver != null && (uRL = relativeResourceResolver.getResource(string)) != null) {
            return uRL.toString();
        }
        uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = "file:" + string2;
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new WsdlException("Failed to construct WSDL relative URL.Tried the following locations: '" + string + "', '" + string2 + "', " + string3 + "'.  Unable to get a URL from any of those locations. " + malformedURLException.getMessage() + ", " + malformedURLException2.getMessage());
            }
        }
        try {
            return new URL(uRL, string).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WsdlException("Failed to construct WSDL relative URL using rootURL='" + uRL + "', location='" + string + "'. " + malformedURLException.getMessage());
        }
    }

    public static SoapAddress getSoapAddress(WsdlPort wsdlPort) {
        SoapAddress soapAddress = null;
        soapAddress = (SoapAddress)wsdlPort.getExtension("SOAP11-address");
        if (soapAddress == null) {
            soapAddress = (SoapAddress)wsdlPort.getExtension("SOAP12-address");
        }
        return soapAddress;
    }

    public static boolean isSoap12(WsPort wsPort) {
        if (wsPort != null) {
            String string = wsPort.getWsdlPort().getBinding().getBindingType();
            return "SOAP12".equals(string);
        }
        return false;
    }

    public static EndpointReferenceWsdlExtension getEndpointReferencelExtension(WsdlPort wsdlPort) {
        return (EndpointReferenceWsdlExtension)wsdlPort.getExtension("EndPonit-Reference");
    }

    public static String getMimeType(String string, WsdlBindingMessage wsdlBindingMessage) {
        if (wsdlBindingMessage == null) {
            return null;
        }
        String string2 = null;
        MimeMultipartRelated mimeMultipartRelated = MimeMultipartRelated.narrow(wsdlBindingMessage);
        if (mimeMultipartRelated != null) {
            List<MimePart> list = mimeMultipartRelated.getParts();
            for (MimePart mimePart : list) {
                List<MimeContent> list2 = MimeContent.narrow(mimePart);
                for (MimeContent mimeContent : list2) {
                    if (!string.equals(mimeContent.getPart())) continue;
                    string2 = mimeContent.getType();
                    return string2;
                }
            }
        }
        return string2;
    }
}

