/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlPort;

public class WsdlWriter {
    private Element root;
    private Map namespaces = new HashMap();
    private int count = 0;
    private static final String PREFIX = "WL5G3N";
    HashSet<String> reservedPrefixes = new HashSet();
    private Document document;
    private String targetNS;
    private WsdlAddressInfo wsdlAddressInfo;
    private WsdlPort currentWsdlPort;
    private String relativeToRootFile = "";
    private Map attachedPolices = new LinkedHashMap();

    public WsdlWriter(Document document, Element element, String string) {
        this.root = element;
        this.document = document;
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        this.namespaces.put(string, "");
    }

    public WsdlWriter() {
    }

    public void setWsdlAddressInfo(WsdlAddressInfo wsdlAddressInfo) {
        this.wsdlAddressInfo = wsdlAddressInfo;
    }

    public WsdlAddressInfo getWsdlAddressInfo() {
        return this.wsdlAddressInfo;
    }

    public void setCurrentWsdlPort(WsdlPort wsdlPort) {
        this.currentWsdlPort = wsdlPort;
    }

    public String getImportPrefix() {
        if (this.wsdlAddressInfo != null) {
            return this.wsdlAddressInfo.getImportPrefix();
        }
        return null;
    }

    public String getEndpointURL(String string) {
        if (this.wsdlAddressInfo != null && this.currentWsdlPort != null) {
            return this.wsdlAddressInfo.getServiceUrl(this.currentWsdlPort.getName(), string);
        }
        return null;
    }

    public String getTargetNS() {
        return this.targetNS;
    }

    public void setTargetNS(String string) {
        this.targetNS = string;
    }

    public String getRelativeToRootFile() {
        return this.relativeToRootFile;
    }

    public void setRelativeToRootFile(String string) {
        this.relativeToRootFile = string;
    }

    public void setAttachedPolices(Map map) {
        this.attachedPolices = map;
    }

    public Map getAttachedPolices() {
        return this.attachedPolices;
    }

    public void addPrefix(String string, String string2) {
        if (string.startsWith(PREFIX)) {
            this.reservedPrefixes.add(string);
        }
        this.namespaces.put(string2, string);
        this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
    }

    public String createPrefix(String string) {
        String string2 = (String)this.namespaces.get(string);
        if (string2 == null) {
            do {
                string2 = PREFIX + this.count;
                ++this.count;
            } while (this.reservedPrefixes.contains(string2));
            this.addPrefix(string2, string);
        } else if (string2.startsWith(PREFIX) && !this.reservedPrefixes.contains(string2)) {
            this.reservedPrefixes.add(string2);
        }
        return string2;
    }

    public void setAttribute(Element element, String string, String string2, QName qName) {
        String string3 = this.createPrefix(qName.getNamespaceURI());
        if ("".equals(string3)) {
            this.setAttribute(element, string, string2, qName.getLocalPart());
        } else {
            this.setAttribute(element, string, string2, string3 + ":" + qName.getLocalPart());
        }
    }

    public void setAttribute(Element element, String string, String string2, String string3) {
        if (string2 == null || WsdlConstants.wsdlNS.equals(string2)) {
            element.setAttribute(string, string3);
        } else {
            String string4 = this.createPrefix(string2);
            if ("".equals(string4)) {
                element.setAttributeNS(string2, string, string3);
            } else {
                element.setAttributeNS(string2, string4 + ":" + string, string3);
            }
        }
    }

    public Element addChild(Element element, String string, String string2) {
        String string3 = this.createPrefix(string2);
        Element element2 = "".equals(string3) ? this.document.createElementNS(string2, string) : this.document.createElementNS(string2, string3 + ":" + string);
        element.appendChild(element2);
        return element2;
    }

    public void addText(Element element, String string) {
        if (string != null) {
            element.appendChild(this.document.createTextNode(string));
        }
    }

    public boolean isSameNS(String string) {
        if (this.targetNS == null || this.targetNS.equals("")) {
            return string == null || string.equals("");
        }
        return this.targetNS.equals(string);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

