/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.http;

import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;

public final class HttpAddress
implements WsdlExtension {
    private static final String KEY = "HTTP-address";
    private String location;
    private static final boolean verbose = Verbose.isVerbose(HttpAddress.class);

    public HttpAddress(String string) {
        this.location = string;
    }

    HttpAddress() {
    }

    public String getKey() {
        return KEY;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public static HttpAddress narrow(WsdlPort wsdlPort) {
        return (HttpAddress)wsdlPort.getExtension(KEY);
    }

    public void parse(Element element, WsdlPort wsdlPort) throws WsdlException {
        this.location = WsdlReader.getMustAttribute(element, null, "location");
        int n = this.location.indexOf(":");
        if (wsdlPort instanceof WsdlPortBuilder) {
            WsdlPortBuilder wsdlPortBuilder = (WsdlPortBuilder)wsdlPort;
            if (n != -1) {
                wsdlPortBuilder.setTransport(this.location.substring(0, n));
            } else {
                wsdlPortBuilder.setTransport("http");
            }
        }
        if (verbose) {
            Verbose.log("Endpoint location :" + this.location);
        }
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "address", "http://schemas.xmlsoap.org/wsdl/http/");
        String string = wsdlWriter.getEndpointURL(this.location);
        if (string != null) {
            wsdlWriter.setAttribute(element2, "location", null, string);
        } else {
            wsdlWriter.setAttribute(element2, "location", null, this.location);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("location", this.location);
        toStringWriter.end();
    }

    public static HttpAddress attach(WsdlPort wsdlPort) {
        HttpAddress httpAddress = new HttpAddress();
        wsdlPort.putExtension(httpAddress);
        if (wsdlPort instanceof WsdlPortBuilder) {
            ((WsdlPortBuilder)wsdlPort).setTransport("http");
        }
        return httpAddress;
    }
}

