/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.net.URISyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.wsdl.WsdlDocumentation;
import weblogic.wsee.wsdl.WsdlElement;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.internal.WsdlDocumentationImpl;

public class WsdlBase
implements WsdlElement {
    private WsdlDocumentationImpl info = null;

    public void setDocumentation(WsdlDocumentationImpl wsdlDocumentationImpl) {
        this.info = wsdlDocumentationImpl;
    }

    public WsdlDocumentation getDocumentation() {
        return this.info;
    }

    public void writeDocumentation(Element element, WsdlWriter wsdlWriter) {
        if (this.info != null) {
            this.info.write(element, wsdlWriter);
        }
    }

    public Element getFirstChildElement(Element element) {
        Node node;
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public void addDocumentation(Element element) throws WsdlException {
        Element element2 = this.getFirstChildElement(element);
        if (element2 != null && "documentation".equals(element2.getLocalName())) {
            WsdlDocumentationImpl wsdlDocumentationImpl = new WsdlDocumentationImpl();
            wsdlDocumentationImpl.parse(element2, null);
            this.setDocumentation(wsdlDocumentationImpl);
        } else {
            this.setDocumentation(null);
        }
    }

    protected PolicyURIs getPolicyUri(Element element) throws WsdlException {
        String string = WsdlReader.getAttribute(element, "http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyURIs");
        if (null == string) {
            string = WsdlReader.getAttribute(element, "http://www.w3.org/ns/ws-policy", "PolicyURIs");
        }
        if (string != null) {
            try {
                return new PolicyURIs(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WsdlException(uRISyntaxException.getMessage());
            }
        }
        return null;
    }
}

