/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.internal.WsdlBindingOperationImpl;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlBindingImpl
extends WsdlExtensibleImpl
implements WsdlBindingBuilder {
    private QName name;
    private QName type;
    private Map<QName, WsdlBindingOperationBuilder> operationList = new LinkedHashMap<QName, WsdlBindingOperationBuilder>();
    private PolicyURIs policyUris;
    private WsdlDefinitionsBuilder definitions;
    private WsdlPortTypeBuilder portType;
    private String bindingType = "unknown";
    private String transportProtocol = "unknown";
    private String transportURI = null;

    WsdlBindingImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this.definitions = wsdlDefinitionsBuilder;
    }

    WsdlBindingImpl(QName qName, QName qName2, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this(wsdlDefinitionsBuilder);
        this.name = qName;
        this.setPortType(qName2);
    }

    private void setPortType(QName qName) {
        this.type = qName;
    }

    @Override
    public String getBindingType() {
        return this.bindingType;
    }

    @Override
    public void setBindingType(String string) {
        this.bindingType = string;
    }

    @Override
    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    public void setTransportProtocol(String string) {
        this.transportProtocol = string;
    }

    @Override
    public void setTransportURI(String string) {
        this.transportURI = string;
    }

    @Override
    public String getTransportURI() {
        return this.transportURI;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public WsdlPortTypeBuilder getPortType() {
        if (this.portType == null) {
            this.portType = this.definitions.getPortTypes().get(this.type);
        }
        return this.portType;
    }

    @Override
    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    @Override
    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("type", this.type);
        toStringWriter.writeArray("operationList", this.operationList.keySet().iterator());
        toStringWriter.writeArray("extensions", this.getExtensionKeys().iterator());
        toStringWriter.end();
    }

    @Override
    public WsdlBindingOperationBuilder addOperation(WsdlOperationBuilder wsdlOperationBuilder) {
        WsdlBindingOperationImpl wsdlBindingOperationImpl = new WsdlBindingOperationImpl(wsdlOperationBuilder.getName(), this);
        this.operationList.put(wsdlOperationBuilder.getName(), wsdlBindingOperationImpl);
        return wsdlBindingOperationImpl;
    }

    public WsdlBindingOperationBuilder getOperation(QName qName) {
        return this.operationList.get(qName);
    }

    @Override
    protected void parseAttributes(Element element, String string) throws WsdlException {
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        String string3 = WsdlReader.getMustAttribute(element, null, "type");
        this.setPortType(WsdlReader.createQName(element, string3));
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    @Override
    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        if ("operation".equals(element.getLocalName())) {
            this.parseOperation(element, this.type.getNamespaceURI());
            return null;
        }
        WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
        return wsdlExtensionParser.parseBinding(this, element);
    }

    private void parseOperation(Element element, String string) throws WsdlException {
        WsdlBindingOperationImpl wsdlBindingOperationImpl = new WsdlBindingOperationImpl(this);
        wsdlBindingOperationImpl.parse(element, string);
        this.operationList.put(wsdlBindingOperationImpl.getName(), wsdlBindingOperationImpl);
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        if (!wsdlWriter.isSameNS(this.getName().getNamespaceURI())) {
            return;
        }
        Element element2 = wsdlWriter.addChild(element, "binding", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        wsdlWriter.setAttribute(element2, "type", WsdlConstants.wsdlNS, this.type);
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        this.writeExtensions(element2, wsdlWriter);
        for (WsdlBindingOperationBuilder wsdlBindingOperationBuilder : this.getOperations().values()) {
            wsdlBindingOperationBuilder.write(element2, wsdlWriter);
        }
    }

    @Override
    public Map<QName, WsdlBindingOperationBuilder> getOperations() {
        return this.operationList;
    }
}

