/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;

public final class WsdlBindingMessageImpl
extends WsdlExtensibleImpl
implements WsdlBindingMessageBuilder {
    private String name;
    private WsdlBindingOperationBuilder operation;
    private WsdlMessageBuilder message;
    private PolicyURIs policyUris;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int FAULT = 2;
    public static final int UNKNOWN = -1;
    private int type = -1;

    WsdlBindingMessageImpl(WsdlBindingOperationBuilder wsdlBindingOperationBuilder, int n) {
        this.operation = wsdlBindingOperationBuilder;
        this.type = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public WsdlBindingOperationBuilder getBindingOperation() {
        return this.operation;
    }

    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    public WsdlMessageBuilder getMessage() throws WsdlException {
        if (this.message != null) {
            return this.message;
        }
        QName qName = this.operation.getName();
        WsdlPortTypeBuilder wsdlPortTypeBuilder = this.getBindingOperation().getBinding().getPortType();
        WsdlOperationBuilder wsdlOperationBuilder = wsdlPortTypeBuilder.getOperations().get(qName);
        if (this.type == 0) {
            this.message = wsdlOperationBuilder.getInput();
        } else if (this.type == 1) {
            this.message = wsdlOperationBuilder.getOutput();
        } else if (this.type == 2) {
            if (this.name == null) {
                throw new WsdlException("Name can not be null");
            }
            this.message = wsdlOperationBuilder.getFaults().get(this.name);
        } else {
            throw new WsdlException("Unknown message type");
        }
        return this.message;
    }

    public int getType() {
        return this.type;
    }

    void flipTypeForCallback() {
        if (this.type == 0) {
            this.type = 1;
        } else if (this.type == 1) {
            this.type = 0;
        }
    }

    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
        WsdlExtension wsdlExtension = wsdlExtensionParser.parseBindingMessage(this, element);
        return wsdlExtension;
    }

    protected void parseAttributes(Element element, String string) throws WsdlException {
        this.setName(element.getAttribute("name"));
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = this.getType() == 0 ? wsdlWriter.addChild(element, "input", WsdlConstants.wsdlNS) : (this.getType() == 1 ? wsdlWriter.addChild(element, "output", WsdlConstants.wsdlNS) : wsdlWriter.addChild(element, "fault", WsdlConstants.wsdlNS));
        if (this.name != null && this.name.length() > 0) {
            element2.setAttribute("name", this.name);
        }
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        this.writeExtensions(element2, wsdlWriter);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("type", this.type);
        toStringWriter.writeField("extensionList", this.getExtensions());
        toStringWriter.end();
    }
}

