/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.NameValueList;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingOperationBuilder;
import weblogic.wsee.wsdl.internal.WsdlBindingMessageImpl;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlBindingOperationImpl
extends WsdlExtensibleImpl
implements WsdlBindingOperationBuilder {
    private QName name;
    private WsdlBindingMessageImpl input;
    private WsdlBindingMessageImpl output;
    private PolicyURIs policyUris;
    private NameValueList faultList = new NameValueList();
    private WsdlBindingBuilder binding;

    WsdlBindingOperationImpl(WsdlBindingBuilder wsdlBindingBuilder) {
        this.binding = wsdlBindingBuilder;
    }

    WsdlBindingOperationImpl(QName qName, WsdlBindingBuilder wsdlBindingBuilder) {
        this(wsdlBindingBuilder);
        this.name = qName;
    }

    @Override
    public WsdlBindingBuilder getBinding() {
        return this.binding;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public WsdlBindingMessageBuilder getInput() {
        return this.input;
    }

    @Override
    public WsdlBindingMessageBuilder createInput() {
        assert (this.input == null);
        this.input = new WsdlBindingMessageImpl(this, 0);
        return this.input;
    }

    @Override
    public WsdlBindingMessageBuilder getOutput() {
        return this.output;
    }

    @Override
    public WsdlBindingMessageBuilder createOutput() {
        assert (this.output == null);
        this.output = new WsdlBindingMessageImpl(this, 1);
        return this.output;
    }

    @Override
    public void flipCallbackInputAndOutput() {
        WsdlBindingMessageImpl wsdlBindingMessageImpl = this.input;
        this.input = this.output;
        this.output = wsdlBindingMessageImpl;
        if (this.input != null) {
            this.input.flipTypeForCallback();
        }
        if (this.output != null) {
            this.output.flipTypeForCallback();
        }
    }

    @Override
    public Map<String, WsdlBindingMessageBuilder> getFaults() {
        HashMap<String, WsdlBindingMessageBuilder> hashMap = new HashMap<String, WsdlBindingMessageBuilder>(this.faultList.size());
        int n = 0;
        Iterator iterator = this.faultList.values();
        while (iterator.hasNext()) {
            WsdlBindingMessageBuilder wsdlBindingMessageBuilder = (WsdlBindingMessageBuilder)iterator.next();
            hashMap.put(wsdlBindingMessageBuilder.getName(), wsdlBindingMessageBuilder);
            ++n;
        }
        return hashMap;
    }

    public WsdlBindingMessageBuilder getFault(String string) {
        Iterator iterator = this.faultList.values();
        while (iterator.hasNext()) {
            WsdlBindingMessageBuilder wsdlBindingMessageBuilder = (WsdlBindingMessageBuilder)iterator.next();
            if (!wsdlBindingMessageBuilder.getName().equals(string)) continue;
            return wsdlBindingMessageBuilder;
        }
        return null;
    }

    @Override
    public WsdlBindingMessageBuilder createFault(String string) {
        WsdlBindingMessageImpl wsdlBindingMessageImpl = new WsdlBindingMessageImpl(this, 2);
        wsdlBindingMessageImpl.setName(string);
        this.faultList.put(string, wsdlBindingMessageImpl);
        return wsdlBindingMessageImpl;
    }

    @Override
    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    @Override
    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    @Override
    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        if (WsdlReader.tagEquals(element, "input", WsdlConstants.wsdlNS)) {
            this.input = new WsdlBindingMessageImpl(this, 0);
            this.input.parse(element, string);
        } else if (WsdlReader.tagEquals(element, "output", WsdlConstants.wsdlNS)) {
            this.output = new WsdlBindingMessageImpl(this, 1);
            this.output.parse(element, string);
        } else if (WsdlReader.tagEquals(element, "fault", WsdlConstants.wsdlNS)) {
            WsdlBindingMessageImpl wsdlBindingMessageImpl = new WsdlBindingMessageImpl(this, 2);
            wsdlBindingMessageImpl.parse(element, string);
            this.faultList.put(wsdlBindingMessageImpl.getName(), wsdlBindingMessageImpl);
        } else {
            WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
            WsdlExtension wsdlExtension = wsdlExtensionParser.parseBindingOperation(this, element);
            return wsdlExtension;
        }
        return null;
    }

    @Override
    protected void parseAttributes(Element element, String string) throws WsdlException {
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "operation", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        this.writeExtensions(element2, wsdlWriter);
        if (this.input != null) {
            this.input.write(element2, wsdlWriter);
        }
        if (this.output != null) {
            this.output.write(element2, wsdlWriter);
        }
        Iterator iterator = this.faultList.values();
        while (iterator.hasNext()) {
            WsdlBindingMessageBuilder wsdlBindingMessageBuilder = (WsdlBindingMessageBuilder)iterator.next();
            wsdlBindingMessageBuilder.write(element2, wsdlWriter);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("input", this.input);
        toStringWriter.writeField("output", this.output);
        toStringWriter.writeField("faultList", this.faultList);
        toStringWriter.writeField("extensionList", this.getExtensions());
        toStringWriter.end();
    }
}

