/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.util.IOUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.RelativeResourceResolver;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlElement;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlImportBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlSchemaBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.builder.WsdlTypesBuilder;
import weblogic.wsee.wsdl.internal.WsdlBindingImpl;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;
import weblogic.wsee.wsdl.internal.WsdlImportImpl;
import weblogic.wsee.wsdl.internal.WsdlMessageImpl;
import weblogic.wsee.wsdl.internal.WsdlPortTypeImpl;
import weblogic.wsee.wsdl.internal.WsdlSchemaImpl;
import weblogic.wsee.wsdl.internal.WsdlServiceImpl;
import weblogic.wsee.wsdl.internal.WsdlTypesImpl;
import weblogic.xml.domimpl.DocumentImpl;
import weblogic.xml.domimpl.Saver;
import weblogic.xml.domimpl.SaverOptions;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlDefinitionsImpl
extends WsdlExtensibleImpl
implements WsdlDefinitionsBuilder {
    private static final String ENC_UTF8 = "UTF-8";
    private WsdlTypesImpl alltypes;
    private WsdlTypesImpl localtypes;
    private Map<QName, WsdlMessageBuilder> messageList = new LinkedHashMap<QName, WsdlMessageBuilder>();
    private Map<QName, WsdlPortTypeBuilder> portTypeList = new LinkedHashMap<QName, WsdlPortTypeBuilder>();
    private Map<QName, WsdlBindingBuilder> bindingList = new LinkedHashMap<QName, WsdlBindingBuilder>();
    private Map<QName, WsdlServiceBuilder> serviceList = new LinkedHashMap<QName, WsdlServiceBuilder>();
    private List<WsdlImportBuilder> importList = new ArrayList<WsdlImportBuilder>();
    private Map<QName, WsdlMessageBuilder> localMessageList = new LinkedHashMap<QName, WsdlMessageBuilder>();
    private Map<QName, WsdlPortTypeBuilder> localPortTypeList = new LinkedHashMap<QName, WsdlPortTypeBuilder>();
    private Map<QName, WsdlBindingBuilder> localBindingList = new LinkedHashMap<QName, WsdlBindingBuilder>();
    private Map<QName, WsdlServiceBuilder> localServiceList = new LinkedHashMap<QName, WsdlServiceBuilder>();
    private String name;
    private String targetNamespace;
    private static final String DEFINITIONS = "definitions";
    private static final String NAME = "name";
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private String wsdlLocation;
    private String encoding = "UTF-8";
    private WsdlSchemaBuilder theOnlySchema;
    private RelativeResourceResolver resolver;
    private Map<String, WsdlDefinitions> knownWsdlLocations = new HashMap<String, WsdlDefinitions>();
    private static final boolean verbose = Verbose.isVerbose(WsdlDefinitions.class);
    public boolean specialModeForCallback81Wsdl;
    private TransportInfo transportInfo;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    void setKnownWsdlLocations(Map<String, WsdlDefinitions> map) {
        if (map != null) {
            this.knownWsdlLocations = map;
        }
    }

    Map<String, WsdlDefinitions> getKnownWsdlLocations() {
        return this.knownWsdlLocations;
    }

    @Override
    public Set<String> getKnownImportedWsdlLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.knownWsdlLocations.keySet());
        hashSet.remove(this.getWsdlLocation());
        return hashSet;
    }

    @Override
    public WsdlSchemaBuilder getTheOnlySchema() {
        return this.theOnlySchema;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public WsdlTypesBuilder addTypes() {
        if (this.localtypes == null) {
            this.localtypes = new WsdlTypesImpl(this.transportInfo);
        }
        return this.localtypes;
    }

    @Override
    public WsdlTypesBuilder getTypes() {
        return this.alltypes != null ? this.alltypes : this.localtypes;
    }

    public WsdlServiceBuilder getService(QName qName) {
        return this.serviceList.get(qName);
    }

    @Override
    public Map<QName, WsdlServiceBuilder> getServices() {
        return this.serviceList;
    }

    @Override
    public WsdlServiceBuilder addService(QName qName) {
        WsdlServiceImpl wsdlServiceImpl = new WsdlServiceImpl(this, qName);
        this.serviceList.put(qName, wsdlServiceImpl);
        this.localServiceList.put(qName, wsdlServiceImpl);
        return wsdlServiceImpl;
    }

    public WsdlPortBuilder getPort(QName qName) {
        for (WsdlServiceBuilder wsdlServiceBuilder : this.getServices().values()) {
            WsdlPortBuilder wsdlPortBuilder = wsdlServiceBuilder.getPorts().get(qName);
            if (wsdlPortBuilder == null) continue;
            return wsdlPortBuilder;
        }
        return null;
    }

    @Override
    public Map<QName, WsdlPortBuilder> getPorts() {
        HashMap<QName, WsdlPortBuilder> hashMap = new HashMap<QName, WsdlPortBuilder>();
        for (WsdlServiceBuilder wsdlServiceBuilder : this.getServices().values()) {
            hashMap.putAll(wsdlServiceBuilder.getPorts());
        }
        return hashMap;
    }

    public WsdlBindingBuilder getBinding(QName qName) {
        return this.bindingList.get(qName);
    }

    @Override
    public WsdlBindingBuilder addBinding(QName qName, WsdlPortTypeBuilder wsdlPortTypeBuilder) {
        WsdlBindingImpl wsdlBindingImpl = new WsdlBindingImpl(qName, wsdlPortTypeBuilder.getName(), this);
        this.bindingList.put(qName, wsdlBindingImpl);
        this.localBindingList.put(qName, wsdlBindingImpl);
        return wsdlBindingImpl;
    }

    @Override
    public Map<QName, WsdlBindingBuilder> getBindings() {
        return this.bindingList;
    }

    public WsdlPortTypeBuilder getPortType(QName qName) {
        WsdlPortTypeBuilder wsdlPortTypeBuilder = this.portTypeList.get(qName);
        if (wsdlPortTypeBuilder == null) {
            throw new IllegalArgumentException("portType not found '" + qName + "'");
        }
        return wsdlPortTypeBuilder;
    }

    @Override
    public WsdlPortTypeBuilder addPortType(QName qName) {
        WsdlPortTypeImpl wsdlPortTypeImpl = new WsdlPortTypeImpl(qName, this);
        this.portTypeList.put(qName, wsdlPortTypeImpl);
        this.localPortTypeList.put(qName, wsdlPortTypeImpl);
        return wsdlPortTypeImpl;
    }

    @Override
    public Map<QName, WsdlPortTypeBuilder> getPortTypes() {
        return this.portTypeList;
    }

    public WsdlMessageBuilder getMessage(QName qName) {
        return this.messageList.get(qName);
    }

    @Override
    public WsdlMessageBuilder addMessage(QName qName) {
        WsdlMessageImpl wsdlMessageImpl = new WsdlMessageImpl(qName);
        this.messageList.put(qName, wsdlMessageImpl);
        this.localMessageList.put(qName, wsdlMessageImpl);
        return wsdlMessageImpl;
    }

    @Override
    public Map<QName, WsdlMessageBuilder> getMessages() {
        return this.messageList;
    }

    @Override
    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    @Override
    public void setRelativeResourceResolver(RelativeResourceResolver relativeResourceResolver) {
        this.resolver = relativeResourceResolver;
    }

    @Override
    public RelativeResourceResolver getRelativeResourceResolver() {
        return this.resolver;
    }

    public static WsdlDefinitions parse(String string) throws WsdlException {
        return WsdlDefinitionsImpl.parse((TransportInfo)null, string);
    }

    static WsdlDefinitions parse(TransportInfo transportInfo, String string) throws WsdlException {
        return WsdlDefinitionsImpl.parse(transportInfo, string, null);
    }

    public static WsdlDefinitions parse(TransportInfo transportInfo, String string, RelativeResourceResolver relativeResourceResolver) throws WsdlException {
        return WsdlDefinitionsImpl.parse(transportInfo, string, relativeResourceResolver, new HashMap<String, WsdlDefinitions>());
    }

    static WsdlDefinitionsBuilder parse(TransportInfo transportInfo, String string, RelativeResourceResolver relativeResourceResolver, Map<String, WsdlDefinitions> map) throws WsdlException {
        if (verbose) {
            Verbose.log("Parsing WSDL :" + string);
        }
        WsdlDefinitionsImpl wsdlDefinitionsImpl = new WsdlDefinitionsImpl();
        wsdlDefinitionsImpl.setKnownWsdlLocations(map);
        wsdlDefinitionsImpl.setRelativeResourceResolver(relativeResourceResolver);
        wsdlDefinitionsImpl.wsdlLocation = string;
        wsdlDefinitionsImpl.setTransportInfo(transportInfo);
        wsdlDefinitionsImpl.parse(WsdlReader.getDocument(transportInfo, string));
        return wsdlDefinitionsImpl;
    }

    void setTransportInfo(TransportInfo transportInfo) {
        this.transportInfo = transportInfo;
    }

    public static WsdlDefinitions parse(InputSource inputSource) throws WsdlException {
        if (verbose) {
            Verbose.log("Parsing WSDL :" + inputSource.getSystemId());
        }
        WsdlDefinitionsImpl wsdlDefinitionsImpl = new WsdlDefinitionsImpl();
        if (inputSource.getSystemId() == null) {
            throw new WsdlException("SystemID must be set on InputSource");
        }
        wsdlDefinitionsImpl.wsdlLocation = inputSource.getSystemId();
        wsdlDefinitionsImpl.parse(WsdlReader.getDocument(inputSource));
        return wsdlDefinitionsImpl;
    }

    public static WsdlDefinitions parse(Document document, String string) throws WsdlException {
        if (verbose) {
            Verbose.log("Parsing WSDL :" + string);
        }
        WsdlDefinitionsImpl wsdlDefinitionsImpl = new WsdlDefinitionsImpl();
        if (string == null) {
            throw new WsdlException("location must not be null");
        }
        wsdlDefinitionsImpl.wsdlLocation = string;
        wsdlDefinitionsImpl.parse(document);
        return wsdlDefinitionsImpl;
    }

    void parse(Document document) throws WsdlException {
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new WsdlException("Invalid Wsdl file found. ");
        }
        if (document instanceof DocumentImpl) {
            DocumentImpl documentImpl = (DocumentImpl)document;
            this.encoding = documentImpl.getXmlEncoding();
            if (this.encoding == null) {
                this.encoding = ENC_UTF8;
            }
        }
        if (element.getLocalName().equals("schema")) {
            this.theOnlySchema = new WsdlSchemaImpl(this, this.transportInfo);
            this.theOnlySchema.parse(element, this.wsdlLocation);
            this.localtypes = new WsdlTypesImpl(this.transportInfo);
            this.localtypes.addSchema(this.theOnlySchema);
            this.alltypes = this.localtypes;
        } else {
            WsdlReader.checkWsdlDefinitions(DEFINITIONS, element);
            WsdlReader.checkWsdlNamespace(element);
            super.parse(element, null);
        }
    }

    private void importDefinition() {
        this.alltypes = new WsdlTypesImpl(this.transportInfo);
        this.alltypes.addTypes(this.localtypes);
        for (WsdlImportBuilder wsdlImportBuilder : this.importList) {
            this.importDefinition((WsdlDefinitionsImpl)wsdlImportBuilder.getDefinitions());
        }
    }

    private void importDefinition(WsdlDefinitionsImpl wsdlDefinitionsImpl) {
        if (wsdlDefinitionsImpl.alltypes != null) {
            if (wsdlDefinitionsImpl.theOnlySchema != null) {
                this.alltypes.addSchemaAsFirst(wsdlDefinitionsImpl.theOnlySchema);
            } else {
                this.alltypes.addTypes(wsdlDefinitionsImpl.alltypes);
            }
        }
        for (Map.Entry<QName, WsdlMessageBuilder> entry : wsdlDefinitionsImpl.messageList.entrySet()) {
            this.messageList.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<QName, WsdlElement> entry : wsdlDefinitionsImpl.portTypeList.entrySet()) {
            this.portTypeList.put(entry.getKey(), (WsdlPortTypeBuilder)entry.getValue());
        }
        for (Map.Entry<QName, WsdlElement> entry : wsdlDefinitionsImpl.bindingList.entrySet()) {
            this.bindingList.put(entry.getKey(), (WsdlBindingBuilder)entry.getValue());
        }
        for (Map.Entry<QName, WsdlElement> entry : wsdlDefinitionsImpl.serviceList.entrySet()) {
            this.serviceList.put(entry.getKey(), (WsdlServiceBuilder)entry.getValue());
        }
    }

    @Override
    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        String string2 = element.getLocalName();
        if ("types".equals(string2)) {
            this.localtypes = new WsdlTypesImpl(this.transportInfo);
            this.localtypes.parse(element, this.wsdlLocation);
        } else if ("import".equals(string2)) {
            WsdlImportImpl wsdlImportImpl = new WsdlImportImpl(this, this.transportInfo);
            wsdlImportImpl.parse(element, this.knownWsdlLocations);
            this.importList.add(wsdlImportImpl);
        } else if ("message".equals(string2)) {
            WsdlMessageImpl wsdlMessageImpl = new WsdlMessageImpl();
            wsdlMessageImpl.parse(element, this.targetNamespace);
            this.localMessageList.put(wsdlMessageImpl.getName(), wsdlMessageImpl);
            this.messageList.put(wsdlMessageImpl.getName(), wsdlMessageImpl);
        } else if ("portType".equals(string2)) {
            WsdlPortTypeImpl wsdlPortTypeImpl = new WsdlPortTypeImpl(this);
            wsdlPortTypeImpl.parse(element, this.targetNamespace);
            this.localPortTypeList.put(wsdlPortTypeImpl.getName(), wsdlPortTypeImpl);
            this.portTypeList.put(wsdlPortTypeImpl.getName(), wsdlPortTypeImpl);
        } else if ("binding".equals(string2)) {
            WsdlBindingImpl wsdlBindingImpl = new WsdlBindingImpl(this);
            wsdlBindingImpl.parse(element, this.targetNamespace);
            this.localBindingList.put(wsdlBindingImpl.getName(), wsdlBindingImpl);
            this.bindingList.put(wsdlBindingImpl.getName(), wsdlBindingImpl);
        } else if ("service".equals(string2)) {
            WsdlServiceImpl wsdlServiceImpl = new WsdlServiceImpl(this);
            wsdlServiceImpl.parse(element, this.targetNamespace);
            this.localServiceList.put(wsdlServiceImpl.getName(), wsdlServiceImpl);
            this.serviceList.put(wsdlServiceImpl.getName(), wsdlServiceImpl);
        } else if (!"documentation".equals(string2)) {
            WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
            return wsdlExtensionParser.parseDefinitions(this, element);
        }
        this.importDefinition();
        return null;
    }

    @Override
    protected void parseAttributes(Element element, String string) {
        this.name = element.getAttributeNS(null, NAME);
        this.targetNamespace = element.getAttributeNS(null, TARGET_NAMESPACE);
    }

    public void write(OutputStream outputStream) throws IOException, WsdlException {
        this.write(outputStream, null);
    }

    public void writeToFile(File file) throws IOException, WsdlException {
        this.writeToFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(File file, String string) throws IOException, WsdlException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        OutputStream outputStream = IOUtil.createEncodedFileOutputStream(file, string);
        try {
            this.write(outputStream, null, string);
            for (WsdlImportBuilder wsdlImportBuilder : this.importList) {
                if (wsdlImportBuilder.hasCirularImport()) continue;
                wsdlImportBuilder.writeToFile(file, string);
            }
            if (this.localtypes != null) {
                this.localtypes.writeImportToFile(file, string);
            }
            if (StringUtil.isEmpty(this.wsdlLocation)) {
                this.wsdlLocation = file.getAbsolutePath();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            outputStream.flush();
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        outputStream.flush();
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void write(OutputStream outputStream, WsdlAddressInfo wsdlAddressInfo) throws IOException, WsdlException {
        this.write(outputStream, wsdlAddressInfo, this.encoding);
    }

    @Override
    public void write(OutputStream outputStream, WsdlAddressInfo wsdlAddressInfo, String string) throws IOException, WsdlException {
        Document document = this.toDocument(wsdlAddressInfo);
        SaverOptions saverOptions = SaverOptions.getDefaults();
        saverOptions.setPrettyPrint(true);
        saverOptions.setWriteXmlDeclaration(true);
        if (string != null) {
            saverOptions.setEncoding(string);
        }
        Saver.save((OutputStream)outputStream, (Document)document, (SaverOptions)saverOptions);
    }

    private Document toDocument(WsdlAddressInfo wsdlAddressInfo) throws WsdlException {
        DocumentBuilderFactory documentBuilderFactory = WebLogicDocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            this.write(document, wsdlAddressInfo);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WsdlException("Failed to create XML document", parserConfigurationException);
        }
    }

    private void write(Document document, WsdlAddressInfo wsdlAddressInfo) throws WsdlException {
        Object object3;
        Object object22;
        Collection<WsdlMessageBuilder> collection;
        if (this.theOnlySchema != null) {
            WsdlWriter wsdlWriter = new WsdlWriter();
            wsdlWriter.setWsdlAddressInfo(wsdlAddressInfo);
            this.theOnlySchema.write(document, wsdlWriter);
            return;
        }
        Element element = document.createElementNS(WsdlConstants.wsdlNS, DEFINITIONS);
        document.appendChild(element);
        WsdlWriter wsdlWriter = new WsdlWriter(document, element, "");
        if (this.getExtension("unknown") != null && this.localtypes != null) {
            collection = this.localtypes.getNameSpaceDefs();
            for (Object k : ((HashMap)((Object)collection)).keySet()) {
                object22 = ((HashMap)((Object)collection)).get(k);
                wsdlWriter.addPrefix((String)k, (String)object22);
            }
        }
        wsdlWriter.setWsdlAddressInfo(wsdlAddressInfo);
        if (!StringUtil.isEmpty(this.name)) {
            wsdlWriter.setAttribute(element, NAME, null, this.name);
        }
        wsdlWriter.setAttribute(element, TARGET_NAMESPACE, null, this.targetNamespace);
        wsdlWriter.setTargetNS(this.targetNamespace);
        for (WsdlImportBuilder wsdlImportBuilder : this.importList) {
            wsdlImportBuilder.write(element, wsdlWriter);
        }
        this.writeExtensions(element, wsdlWriter);
        if (this.localtypes != null) {
            this.localtypes.write(element, wsdlWriter);
        }
        collection = this.specialModeForCallback81Wsdl ? this.messageList.values() : this.localMessageList.values();
        for (WsdlMessageBuilder wsdlMessageBuilder : collection) {
            wsdlMessageBuilder.write(element, wsdlWriter);
        }
        Collection<WsdlPortTypeBuilder> collection2 = this.specialModeForCallback81Wsdl ? this.portTypeList.values() : this.localPortTypeList.values();
        for (Object object22 : collection2) {
            object22.write(element, wsdlWriter);
        }
        Collection<WsdlBindingBuilder> collection3 = this.specialModeForCallback81Wsdl ? this.bindingList.values() : this.localBindingList.values();
        for (Object object3 : collection3) {
            object3.write(element, wsdlWriter);
        }
        object22 = this.specialModeForCallback81Wsdl ? this.serviceList.values() : this.localServiceList.values();
        object3 = object22.iterator();
        while (object3.hasNext()) {
            WsdlServiceBuilder wsdlServiceBuilder = (WsdlServiceBuilder)object3.next();
            wsdlServiceBuilder.write(element, wsdlWriter);
        }
    }

    @Override
    public List<WsdlDefinitionsBuilder> getImportedWsdlDefinitions() {
        ArrayList<WsdlDefinitionsBuilder> arrayList = new ArrayList<WsdlDefinitionsBuilder>();
        for (WsdlImportBuilder wsdlImportBuilder : this.importList) {
            WsdlDefinitionsImpl wsdlDefinitionsImpl = (WsdlDefinitionsImpl)wsdlImportBuilder.getDefinitions();
            if (wsdlImportBuilder.hasCirularImport()) {
                if (wsdlImportBuilder.cirularImportResovled()) continue;
                wsdlDefinitionsImpl.importDefinition();
                this.importDefinition(wsdlDefinitionsImpl);
                ((WsdlImportImpl)wsdlImportBuilder).setCirularImportResovled(true);
                continue;
            }
            arrayList.add(wsdlDefinitionsImpl);
        }
        return arrayList;
    }

    @Override
    public WsdlDefinitionsBuilder findImport(String string) {
        for (WsdlImportBuilder wsdlImportBuilder : this.importList) {
            WsdlDefinitionsBuilder wsdlDefinitionsBuilder;
            if (wsdlImportBuilder.isRelative() && string.equals(wsdlImportBuilder.getLocation())) {
                return wsdlImportBuilder.getDefinitions();
            }
            if (wsdlImportBuilder.hasCirularImport() || (wsdlDefinitionsBuilder = wsdlImportBuilder.getDefinitions().findImport(string)) == null) continue;
            return wsdlDefinitionsBuilder;
        }
        return null;
    }

    @Override
    public WsdlDefinitionsBuilder findAbsoluteImport(String string) {
        for (WsdlImportBuilder wsdlImportBuilder : this.importList) {
            if (!wsdlImportBuilder.isRelative() && string.equals(wsdlImportBuilder.getLocation())) {
                return wsdlImportBuilder.getDefinitions();
            }
            WsdlDefinitionsBuilder wsdlDefinitionsBuilder = wsdlImportBuilder.getDefinitions().findAbsoluteImport(string);
            if (wsdlDefinitionsBuilder == null) continue;
            return wsdlDefinitionsBuilder;
        }
        return null;
    }

    @Override
    public List<WsdlImportBuilder> getImports() {
        return this.importList;
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField(NAME, this.name);
        toStringWriter.writeField(TARGET_NAMESPACE, this.targetNamespace);
        toStringWriter.writeField("wsdlLocation", this.wsdlLocation);
        toStringWriter.writeArray("message", this.messageList.keySet().iterator());
        toStringWriter.writeArray("portType", this.portTypeList.keySet().iterator());
        toStringWriter.writeArray("binding", this.bindingList.keySet().iterator());
        toStringWriter.writeArray("service", this.serviceList.keySet().iterator());
        toStringWriter.end();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }
}

