/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.internal.WsdlBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsdlExtensibleImpl
extends WsdlBase
implements WsdlExtensible {
    private Map<String, List<WsdlExtension>> extensions = new HashMap<String, List<WsdlExtension>>();

    @Override
    public WsdlExtension getExtension(String string) {
        List<WsdlExtension> list = this.extensions.get(string);
        if (list != null) {
            return list.iterator().next();
        }
        return null;
    }

    @Override
    public List<WsdlExtension> getExtensionList(String string) {
        List list = this.extensions.get(string);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    @Override
    public void putExtension(WsdlExtension wsdlExtension) {
        if (wsdlExtension != null) {
            List<WsdlExtension> list = this.extensions.get(wsdlExtension.getKey());
            if (list == null) {
                list = new ArrayList<WsdlExtension>();
                this.extensions.put(wsdlExtension.getKey(), list);
            }
            if (!list.contains(wsdlExtension)) {
                list.add(wsdlExtension);
            }
        }
    }

    @Override
    public Map<String, List<WsdlExtension>> getExtensions() {
        return this.extensions;
    }

    public Set<String> getExtensionKeys() {
        return this.extensions.keySet();
    }

    public void parse(Element element, String string) throws WsdlException {
        this.addDocumentation(element);
        this.parseAttributes(element, string);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (WsdlReader.isWhiteSpace(node) || WsdlReader.isDocumentation(node)) continue;
            WsdlReader.checkDomElement(node);
            WsdlExtension wsdlExtension = this.parseChild((Element)node, string);
            this.putExtension(wsdlExtension);
        }
    }

    protected void writeExtensions(Element element, WsdlWriter wsdlWriter) {
        this.writeDocumentation(element, wsdlWriter);
        for (List<WsdlExtension> list : this.extensions.values()) {
            for (WsdlExtension wsdlExtension : list) {
                wsdlExtension.write(element, wsdlWriter);
            }
        }
    }

    protected abstract WsdlExtension parseChild(Element var1, String var2) throws WsdlException;

    protected abstract void parseAttributes(Element var1, String var2) throws WsdlException;
}

