/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Element;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlImport;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlImportBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;
import weblogic.wsee.wsdl.internal.WsdlDefinitionsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlImportImpl
extends WsdlBase
implements WsdlImportBuilder {
    private static final boolean verbose = Verbose.isVerbose(WsdlImport.class);
    private WsdlDefinitionsBuilder definitions;
    private WsdlDefinitionsBuilder parent;
    private String namespace;
    private String location;
    private boolean relative;
    private boolean hasCircularImport = false;
    private boolean circularImportResovled;
    private TransportInfo transportInfo;

    WsdlImportImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, TransportInfo transportInfo) {
        this.parent = wsdlDefinitionsBuilder;
        this.transportInfo = transportInfo;
    }

    @Override
    public WsdlDefinitionsBuilder getDefinitions() {
        return this.definitions;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public boolean hasCirularImport() {
        return this.hasCircularImport;
    }

    @Override
    public boolean cirularImportResovled() {
        return this.circularImportResovled;
    }

    public void setCirularImportResovled(boolean bl) {
        this.circularImportResovled = bl;
    }

    @Override
    public void parse(Element element, Map<String, WsdlDefinitions> map) throws WsdlException {
        this.addDocumentation(element);
        this.namespace = element.getAttributeNS(null, "namespace");
        this.location = element.getAttributeNS(null, "location");
        if (verbose) {
            Verbose.log("import namespace: " + this.namespace);
            Verbose.log("import location: " + this.location);
        }
        if (this.namespace == null) {
            throw new WsdlException("namespace not specified in import");
        }
        if (this.location == null) {
            throw new WsdlException("location not specified in import");
        }
        String string = this.location;
        try {
            new URL(this.location);
            this.relative = false;
        }
        catch (MalformedURLException malformedURLException) {
            this.relative = true;
            string = WsdlUtils.constructRelativeLocation(this.location, this.parent.getWsdlLocation(), this.parent.getRelativeResourceResolver());
        }
        WsdlDefinitionsBuilder wsdlDefinitionsBuilder = (WsdlDefinitionsBuilder)map.get(string);
        if (wsdlDefinitionsBuilder != null) {
            if (verbose) {
                Verbose.log("ignoring previously imported wsdl at location: " + this.location);
            }
            this.hasCircularImport = true;
            this.definitions = wsdlDefinitionsBuilder;
            return;
        }
        map.put(this.parent.getWsdlLocation(), this.parent);
        this.definitions = WsdlDefinitionsImpl.parse(this.transportInfo, string, null, map);
        this.definitions.setRelativeResourceResolver(this.parent.getRelativeResourceResolver());
        map.put(string, this.definitions);
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "import", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "namespace", WsdlConstants.wsdlNS, this.namespace);
        String string = wsdlWriter.getImportPrefix();
        if (this.isRelative() && string != null) {
            wsdlWriter.setAttribute(element2, "location", WsdlConstants.wsdlNS, string + "/" + this.location);
        } else {
            wsdlWriter.setAttribute(element2, "location", WsdlConstants.wsdlNS, this.location);
        }
        this.writeDocumentation(element2, wsdlWriter);
    }

    @Override
    public void writeToFile(File file, String string) throws IOException, WsdlException {
        if (!this.relative) {
            return;
        }
        File file2 = new File(file.getParentFile(), this.location);
        if (verbose) {
            Verbose.log("Writing import to file " + file2.getAbsolutePath());
        }
        this.definitions.writeToFile(file2, string);
    }

    @Override
    public void writeToFile(File file) throws IOException, WsdlException {
        this.writeToFile(file, null);
    }
}

