/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlFilter;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlPartBuilder;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;
import weblogic.wsee.wsdl.internal.WsdlPartImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlMessageImpl
extends WsdlExtensibleImpl
implements WsdlMessageBuilder {
    private Map<String, WsdlPartBuilder> partList = new LinkedHashMap<String, WsdlPartBuilder>();
    private PolicyURIs policyUris;
    private QName name;

    WsdlMessageImpl() {
    }

    WsdlMessageImpl(QName qName) {
        this();
        this.name = qName;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Map<String, WsdlPartBuilder> getParts() {
        return this.partList;
    }

    public WsdlPartBuilder getPart(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        return this.partList.get(string);
    }

    @Override
    public WsdlPartBuilder addPart(String string) {
        WsdlPartImpl wsdlPartImpl = new WsdlPartImpl(string);
        this.partList.put(string, wsdlPartImpl);
        return wsdlPartImpl;
    }

    @Override
    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    @Override
    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    @Override
    protected void parseAttributes(Element element, String string) throws WsdlException {
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    @Override
    public WsdlExtension parseChild(Element element, String string) throws WsdlException {
        if (WsdlReader.tagEquals(element, "part", WsdlConstants.wsdlNS)) {
            this.parsePart(element, string);
            return null;
        }
        WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
        return wsdlExtensionParser.parseMessage(this, element);
    }

    private void parsePart(Element element, String string) throws WsdlException {
        WsdlPartImpl wsdlPartImpl = new WsdlPartImpl();
        wsdlPartImpl.parse(element, string);
        this.partList.put(wsdlPartImpl.getName(), wsdlPartImpl);
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        if (!wsdlWriter.isSameNS(this.getName().getNamespaceURI())) {
            return;
        }
        Element element2 = wsdlWriter.addChild(element, "message", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        WsdlFilter wsdlFilter = wsdlWriter.getWsdlAddressInfo() == null ? null : wsdlWriter.getWsdlAddressInfo().getWsdlFilter();
        this.writeExtensions(element2, wsdlWriter);
        for (WsdlPartBuilder wsdlPartBuilder : this.getParts().values()) {
            if (wsdlFilter != null && !wsdlFilter.isMessagePartSupported(this.getName(), wsdlPartBuilder.getName())) continue;
            wsdlPartBuilder.write(element2, wsdlWriter);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeArray("partList", this.partList.values().iterator());
        toStringWriter.end();
    }
}

