/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlMethodBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPartBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;
import weblogic.wsee.wsdl.internal.WsdlMethodImpl;
import weblogic.wsee.wsdl.internal.WsdlParameterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlOperationImpl
extends WsdlExtensibleImpl
implements WsdlOperationBuilder {
    private MessageElement input;
    private MessageElement output;
    private Map<String, MessageElement> faultList = new LinkedHashMap<String, MessageElement>();
    private PolicyURIs policyUris;
    private QName name;
    private String parameterOrder;
    private WsdlMethodBuilder wsdlMethod = null;
    public static final int REQUEST_RESPONSE = 0;
    public static final int ONE_WAY = 1;
    public static final int SOLICIT_RESPONSE = 2;
    public static final int NOTIFICATION = 3;
    private int type = 0;
    private WsdlDefinitionsBuilder definitions;

    WsdlOperationImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this.definitions = wsdlDefinitionsBuilder;
    }

    WsdlOperationImpl(QName qName, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this(wsdlDefinitionsBuilder);
        this.name = qName;
    }

    @Override
    public String getParameterOrder() {
        return this.parameterOrder;
    }

    @Override
    public void setParameterOrder(String string) {
        this.parameterOrder = string;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    @Override
    public WsdlMessageBuilder getInput() {
        return this.input == null ? null : this.definitions.getMessages().get(this.input.message);
    }

    @Override
    public String getInputAction() {
        if (this.input == null || this.input.action == null) {
            return null;
        }
        return this.input.action.getActionURI();
    }

    @Override
    public String getInputName() {
        if (this.input == null) {
            return null;
        }
        String string = this.input.getName();
        if (StringUtil.isEmpty(string)) {
            if (this.type == 1 || this.type == 3) {
                string = this.name.getLocalPart();
            } else if (this.type == 0) {
                string = this.name.getLocalPart() + "Request";
            } else if (this.type == 2) {
                string = this.name.getLocalPart() + "Solicit";
            }
        }
        return string;
    }

    @Override
    public PolicyURIs getInputPolicyUris() {
        return this.input == null ? null : this.input.getPolicyUris();
    }

    @Override
    public void setInputPolicyUris(PolicyURIs policyURIs) {
        if (this.input != null) {
            this.input.setPolicyUris(policyURIs);
        }
    }

    @Override
    public WsdlMessageBuilder getOutput() {
        return this.output == null ? null : this.definitions.getMessages().get(this.output.message);
    }

    @Override
    public String getOutputAction() {
        if (this.output == null || this.output.action == null) {
            return null;
        }
        return this.output.action.getActionURI();
    }

    @Override
    public String getOutputName() {
        if (this.output == null) {
            return null;
        }
        String string = this.output.getName();
        if (StringUtil.isEmpty(string)) {
            string = this.type == 1 || this.type == 3 ? this.name.getLocalPart() : this.name.getLocalPart() + "Response";
        }
        return string;
    }

    @Override
    public PolicyURIs getOutputPolicyUris() {
        return this.output == null ? null : this.output.getPolicyUris();
    }

    @Override
    public void setOutputPolicyUris(PolicyURIs policyURIs) {
        if (this.output != null) {
            this.output.setPolicyUris(policyURIs);
        }
    }

    @Override
    public Map<String, WsdlMessageBuilder> getFaults() {
        HashMap<String, WsdlMessageBuilder> hashMap = new HashMap<String, WsdlMessageBuilder>();
        for (MessageElement messageElement : this.faultList.values()) {
            WsdlMessageBuilder wsdlMessageBuilder = this.definitions.getMessages().get(messageElement.message);
            hashMap.put(messageElement.name, wsdlMessageBuilder);
        }
        return hashMap;
    }

    @Override
    public WsdlMethodBuilder getWsdlMethod() {
        return this.getWsdlMethod(false);
    }

    @Override
    public WsdlMethodBuilder getWsdlMethod(boolean bl) {
        if (this.wsdlMethod == null) {
            String string;
            WsdlMessageBuilder wsdlMessageBuilder;
            WsdlMessageBuilder wsdlMessageBuilder2;
            this.wsdlMethod = new WsdlMethodImpl();
            if (this.isWLW81CallbackOperation()) {
                wsdlMessageBuilder2 = this.getOutput();
                wsdlMessageBuilder = this.getInput();
            } else {
                wsdlMessageBuilder2 = this.getInput();
                wsdlMessageBuilder = this.getOutput();
            }
            WsdlPartBuilder wsdlPartBuilder = null;
            String string2 = WsdlUtils.findReturnPart(this);
            if (!StringUtil.isEmpty(string2)) {
                wsdlPartBuilder = wsdlMessageBuilder.getParts().get(string2);
                this.wsdlMethod.setResultPart(wsdlPartBuilder);
            }
            if (StringUtil.isEmpty(string = this.getParameterOrder())) {
                this.fillWithOutParameterOrder(wsdlMessageBuilder2, wsdlMessageBuilder, wsdlPartBuilder);
            } else {
                this.fillWithParameterOrder(wsdlMessageBuilder2, wsdlMessageBuilder, wsdlPartBuilder, string, bl);
            }
        }
        return this.wsdlMethod;
    }

    @Override
    public void flipCallbackInputAndOutputParts() {
        if (this.isWLW81CallbackOperation()) {
            MessageElement messageElement = this.input;
            this.input = this.output;
            this.output = messageElement;
            if (this.type == 2) {
                this.type = 0;
            }
            if (this.type == 3) {
                this.type = 1;
            }
        }
    }

    private void fillWithOutParameterOrder(WsdlMessageBuilder wsdlMessageBuilder, WsdlMessageBuilder wsdlMessageBuilder2, WsdlPartBuilder wsdlPartBuilder) {
        HashSet<WsdlPartBuilder> hashSet = new HashSet<WsdlPartBuilder>();
        if (wsdlMessageBuilder != null) {
            for (WsdlPartBuilder wsdlPartBuilder2 : wsdlMessageBuilder.getParts().values()) {
                WsdlPartBuilder wsdlPartBuilder3 = null;
                if (wsdlMessageBuilder2 != null) {
                    wsdlPartBuilder3 = wsdlMessageBuilder2.getParts().get(wsdlPartBuilder2.getName());
                    if (wsdlPartBuilder3 == null || !wsdlPartBuilder3.equals(wsdlPartBuilder2)) {
                        wsdlPartBuilder3 = null;
                    } else {
                        hashSet.add(wsdlPartBuilder3);
                    }
                }
                this.wsdlMethod.addWsdlParameter(new WsdlParameterImpl(wsdlPartBuilder2, wsdlPartBuilder3));
            }
        }
        if (wsdlMessageBuilder2 != null) {
            for (WsdlPartBuilder wsdlPartBuilder2 : wsdlMessageBuilder2.getParts().values()) {
                if (wsdlPartBuilder2 == wsdlPartBuilder || hashSet.contains(wsdlPartBuilder2)) continue;
                this.wsdlMethod.addWsdlParameter(new WsdlParameterImpl(null, wsdlPartBuilder2));
            }
        }
    }

    private void fillWithParameterOrder(WsdlMessageBuilder wsdlMessageBuilder, WsdlMessageBuilder wsdlMessageBuilder2, WsdlPartBuilder wsdlPartBuilder, String string, boolean bl) {
        WsdlPartBuilder wsdlPartBuilder2;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        object = new HashSet();
        HashSet<WsdlPartBuilder> hashSet = new HashSet<WsdlPartBuilder>();
        for (String object2 : arrayList) {
            wsdlPartBuilder2 = wsdlMessageBuilder.getParts().get(object2);
            if (wsdlPartBuilder2 != null) {
                hashSet.add(wsdlPartBuilder2);
            }
            WsdlPartBuilder wsdlPartBuilder3 = null;
            if (wsdlMessageBuilder2 != null) {
                wsdlPartBuilder3 = wsdlMessageBuilder2.getParts().get(object2);
                if (wsdlPartBuilder3 != null && wsdlPartBuilder2 == null || wsdlPartBuilder2 != null && wsdlPartBuilder2.equals(wsdlPartBuilder3)) {
                    object.add(wsdlPartBuilder3);
                } else {
                    wsdlPartBuilder3 = null;
                }
            }
            if (wsdlPartBuilder2 == null && wsdlPartBuilder3 == null) {
                throw new IllegalArgumentException("No In part or out part found for: " + object2 + " with Parameter Order = " + string);
            }
            this.wsdlMethod.addWsdlParameter(new WsdlParameterImpl(wsdlPartBuilder2, wsdlPartBuilder3));
        }
        if (bl && wsdlMessageBuilder != null) {
            for (WsdlPartBuilder wsdlPartBuilder4 : wsdlMessageBuilder.getParts().values()) {
                if (hashSet.contains(wsdlPartBuilder4)) continue;
                wsdlPartBuilder2 = null;
                if (wsdlMessageBuilder2 != null) {
                    wsdlPartBuilder2 = wsdlMessageBuilder2.getParts().get(wsdlPartBuilder4.getName());
                    if (wsdlPartBuilder2 == null || !wsdlPartBuilder2.equals(wsdlPartBuilder4)) {
                        wsdlPartBuilder2 = null;
                    } else {
                        object.add(wsdlPartBuilder2);
                    }
                }
                this.wsdlMethod.addWsdlParameter(new WsdlParameterImpl(wsdlPartBuilder4, wsdlPartBuilder2));
            }
        }
        if (wsdlMessageBuilder2 != null) {
            for (WsdlPartBuilder wsdlPartBuilder5 : wsdlMessageBuilder2.getParts().values()) {
                if (wsdlPartBuilder5 == wsdlPartBuilder || object.contains(wsdlPartBuilder5)) continue;
                this.wsdlMethod.addWsdlParameter(new WsdlParameterImpl(null, wsdlPartBuilder5));
            }
        }
    }

    public WsdlMessageBuilder getFault(String string) throws WsdlException {
        for (MessageElement messageElement : this.faultList.values()) {
            if (!string.equals(messageElement.name)) continue;
            return this.definitions.getMessages().get(messageElement.message);
        }
        throw new WsdlException("Unable to find fault with name: " + string);
    }

    @Override
    public PolicyURIs getFaultPolicyUris(String string) {
        for (MessageElement messageElement : this.faultList.values()) {
            if (!messageElement.getName().equals(string)) continue;
            return messageElement.getPolicyUris();
        }
        return null;
    }

    @Override
    public void setFaultPolicyUris(String string, PolicyURIs policyURIs) {
        for (MessageElement messageElement : this.faultList.values()) {
            if (!messageElement.getName().equals(string)) continue;
            messageElement.setPolicyUris(policyURIs);
        }
    }

    @Override
    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    @Override
    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    @Override
    public void parse(Element element, String string) throws WsdlException {
        this.addDocumentation(element);
        this.parseAttributes(element, string);
        NodeList nodeList = element.getChildNodes();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (WsdlReader.isWhiteSpace(node)) continue;
            WsdlReader.checkDomElement(node);
            if ("input".equals(node.getLocalName())) {
                if (!bl) {
                    bl = true;
                    bl2 = true;
                }
                this.input = new MessageElement((Element)node, false);
                continue;
            }
            if ("output".equals(node.getLocalName())) {
                if (!bl) {
                    bl = true;
                    bl2 = false;
                }
                this.output = new MessageElement((Element)node, false);
                continue;
            }
            if ("fault".equals(node.getLocalName())) {
                if (!bl) {
                    throw new WsdlException("Fount a fault message before input or output. for operation " + this);
                }
                object = new MessageElement((Element)node, true);
                this.faultList.put(((MessageElement)object).name, (MessageElement)object);
                continue;
            }
            if ("documentation".equals(node.getLocalName())) continue;
            object = this.parseChild((Element)node, string);
            this.putExtension((WsdlExtension)object);
        }
        this.type = bl2 ? (this.output == null ? 1 : 0) : (this.input == null ? 3 : 2);
    }

    @Override
    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
        WsdlExtension wsdlExtension = wsdlExtensionParser.parseOperation(this, element);
        return wsdlExtension;
    }

    @Override
    protected void parseAttributes(Element element, String string) throws WsdlException {
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        this.parameterOrder = WsdlReader.getAttribute(element, null, "parameterOrder");
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "operation", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        if (this.parameterOrder != null) {
            wsdlWriter.setAttribute(element2, "parameterOrder", WsdlConstants.wsdlNS, this.parameterOrder);
        }
        this.writeDocumentation(element2, wsdlWriter);
        if (this.type == 0 || this.type == 1) {
            this.writeInputElement(wsdlWriter, element2);
            this.writeOutputElement(wsdlWriter, element2);
        } else {
            this.writeOutputElement(wsdlWriter, element2);
            this.writeInputElement(wsdlWriter, element2);
        }
        this.writeFault(wsdlWriter, element2);
    }

    private void writeFault(WsdlWriter wsdlWriter, Element element) {
        for (MessageElement messageElement : this.faultList.values()) {
            Element element2 = wsdlWriter.addChild(element, "fault", WsdlConstants.wsdlNS);
            element2.setAttribute("name", messageElement.name);
            wsdlWriter.setAttribute(element2, "message", WsdlConstants.wsdlNS, messageElement.message);
            messageElement.writeDocumentation(element2, wsdlWriter);
        }
    }

    private void writeInputElement(WsdlWriter wsdlWriter, Element element) {
        if (this.input != null) {
            Element element2 = wsdlWriter.addChild(element, "input", WsdlConstants.wsdlNS);
            if (this.input.name != null && this.input.name.length() > 0) {
                wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.input.name);
            }
            wsdlWriter.setAttribute(element2, "message", WsdlConstants.wsdlNS, this.input.message);
            if (this.input.action != null) {
                wsdlWriter.setAttribute(element2, "Action", this.input.action.getActionNamespace(), this.input.action.getActionURI());
            }
            if (this.input.getPolicyUris() != null) {
                this.input.getPolicyUris().write(element2, wsdlWriter);
            }
            this.input.writeDocumentation(element2, wsdlWriter);
        }
    }

    private void writeOutputElement(WsdlWriter wsdlWriter, Element element) {
        if (this.output != null) {
            Element element2 = wsdlWriter.addChild(element, "output", WsdlConstants.wsdlNS);
            if (this.output.name != null && this.output.name.length() > 0) {
                wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.output.name);
            }
            wsdlWriter.setAttribute(element2, "message", WsdlConstants.wsdlNS, this.output.message);
            if (this.output.action != null) {
                wsdlWriter.setAttribute(element2, "Action", this.output.action.getActionNamespace(), this.output.action.getActionURI());
            }
            if (this.output.getPolicyUris() != null) {
                this.output.getPolicyUris().write(element2, wsdlWriter);
            }
            this.output.writeDocumentation(element2, wsdlWriter);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("parameterOrder", this.parameterOrder);
        toStringWriter.writeField("type", this.type);
        toStringWriter.writeField("input", this.input);
        toStringWriter.writeField("output", this.output);
        toStringWriter.writeArray("faultList", this.faultList.values().iterator());
        toStringWriter.end();
    }

    @Override
    public void setInput(WsdlMessageBuilder wsdlMessageBuilder) {
        MessageElement messageElement;
        this.input = messageElement = new MessageElement(wsdlMessageBuilder.getName());
    }

    @Override
    public void setOutput(WsdlMessageBuilder wsdlMessageBuilder) {
        MessageElement messageElement;
        this.output = messageElement = new MessageElement(wsdlMessageBuilder.getName());
    }

    @Override
    public void addFault(WsdlMessageBuilder wsdlMessageBuilder, String string) {
        MessageElement messageElement = new MessageElement(wsdlMessageBuilder.getName());
        messageElement.name = string;
        this.faultList.put(string, messageElement);
    }

    @Override
    public boolean isWrapped() {
        return this.isWrappedNormal() || this.isWrappedWLW81Callback();
    }

    @Override
    public boolean isWrappedNormal() {
        return this.isWrapped(this.getInput(), this.getOutput());
    }

    @Override
    public boolean isWrappedWLW81Callback() {
        if (this.type != 2 && this.type != 3) {
            return false;
        }
        return this.isWrapped(this.getOutput(), this.getInput());
    }

    protected boolean isWrapped(WsdlMessageBuilder wsdlMessageBuilder, WsdlMessageBuilder wsdlMessageBuilder2) {
        if (wsdlMessageBuilder == null) {
            return false;
        }
        Iterator<WsdlPartBuilder> iterator = wsdlMessageBuilder.getParts().values().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        WsdlPart wsdlPart = iterator.next();
        if (iterator.hasNext()) {
            return false;
        }
        if (wsdlPart.getElement() == null) {
            return false;
        }
        String string = this.getName().getLocalPart();
        if (!string.equals(wsdlPart.getElement().getLocalPart())) {
            return false;
        }
        if (wsdlMessageBuilder2 != null) {
            Iterator<WsdlPartBuilder> iterator2 = wsdlMessageBuilder2.getParts().values().iterator();
            if (!iterator2.hasNext()) {
                return false;
            }
            WsdlPart wsdlPart2 = iterator2.next();
            if (iterator2.hasNext()) {
                return false;
            }
            if (wsdlPart2.getElement() == null) {
                return false;
            }
            if (!(string + "Response").equals(wsdlPart2.getElement().getLocalPart())) {
                return false;
            }
            if (!wsdlPart.getElement().getNamespaceURI().equals(wsdlPart2.getElement().getNamespaceURI())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWLW81CallbackOperation() {
        if (this.type != 2 && this.type != 3) {
            return false;
        }
        WsdlMessageBuilder wsdlMessageBuilder = this.getInput();
        WsdlMessageBuilder wsdlMessageBuilder2 = this.getOutput();
        if (wsdlMessageBuilder2 != null) {
            if (this.isWrapped()) {
                return this.isWrappedWLW81Callback();
            }
            Iterator<WsdlPartBuilder> iterator = wsdlMessageBuilder2.getParts().values().iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            WsdlPart wsdlPart = iterator.next();
            if (wsdlPart.getName().equals(this.getName().getLocalPart() + "Result")) {
                return false;
            }
            if (wsdlMessageBuilder == null) {
                return true;
            }
            Iterator<WsdlPartBuilder> iterator2 = wsdlMessageBuilder.getParts().values().iterator();
            if (!iterator2.hasNext()) {
                return true;
            }
            WsdlPart wsdlPart2 = iterator2.next();
            if (iterator2.hasNext()) {
                return false;
            }
            return wsdlPart2.getName().equals(this.getName().getLocalPart() + "Result");
        }
        return false;
    }

    private static class WSAWAction {
        private String actionValue;
        private String actionNamespace;

        public WSAWAction(String string, String string2) {
            this.actionValue = string;
            this.actionNamespace = string2;
        }

        public String getActionURI() {
            return this.actionValue;
        }

        public void setActionURI(String string) {
            this.actionValue = string;
        }

        public String getActionNamespace() {
            return this.actionNamespace;
        }

        public void setActionNamespace(String string) {
            this.actionNamespace = string;
        }
    }

    private static class MessageElement
    extends WsdlBase {
        String name;
        QName message;
        PolicyURIs policyUris;
        WSAWAction action;

        public MessageElement(QName qName) {
            this.message = qName;
        }

        public MessageElement(Element element, boolean bl) throws WsdlException {
            String string;
            this.addDocumentation(element);
            String string2 = WsdlReader.getMustAttribute(element, null, "message");
            this.message = WsdlReader.createQName(element, string2);
            this.name = bl ? WsdlReader.getMustAttribute(element, null, "name") : element.getAttribute("name");
            PolicyURIs policyURIs = this.getPolicyUri(element);
            if (null != policyURIs) {
                this.policyUris = policyURIs;
            }
            if ((string = WsdlReader.getAttribute(element, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action")) != null) {
                this.action = new WSAWAction(string, "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                return;
            }
            if (string == null && (string = WsdlReader.getAttribute(element, "http://www.w3.org/2006/05/addressing/wsdl", "Action")) != null) {
                this.action = new WSAWAction(string, "http://www.w3.org/2006/05/addressing/wsdl");
            }
        }

        public PolicyURIs getPolicyUris() {
            return this.policyUris;
        }

        void setPolicyUris(PolicyURIs policyURIs) {
            this.policyUris = policyURIs;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "[name=" + this.name + " message=" + this.message + "]";
        }
    }
}

