/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlPartBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;

public class WsdlPartImpl
extends WsdlBase
implements WsdlPartBuilder {
    private String name;
    private QName type;
    private QName element;

    WsdlPartImpl() {
    }

    WsdlPartImpl(String string) {
        this();
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName qName) {
        this.type = qName;
    }

    public QName getElement() {
        return this.element;
    }

    public void setElement(QName qName) {
        this.element = qName;
    }

    public void parse(Element element, String string) throws WsdlException {
        Attr attr;
        this.addDocumentation(element);
        this.name = WsdlReader.getMustAttribute(element, null, "name");
        Attr attr2 = element.getAttributeNode("type");
        if (attr2 != null) {
            this.type = WsdlReader.createQName(element, attr2.getValue());
        }
        if ((attr = element.getAttributeNode("element")) != null) {
            this.element = WsdlReader.createQName(element, attr.getValue());
        }
        if (this.type == null && this.element == null) {
            throw new WsdlException("either type or element must be specified for part " + this.getName());
        }
        if (this.type != null && this.element != null) {
            throw new WsdlException("both type and element specified for part " + this.getName() + ". only one can be specified");
        }
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "part", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name);
        if (this.type != null) {
            wsdlWriter.setAttribute(element2, "type", WsdlConstants.wsdlNS, this.type);
        }
        if (this.element != null) {
            wsdlWriter.setAttribute(element2, "element", WsdlConstants.wsdlNS, this.element);
        }
        this.writeDocumentation(element2, wsdlWriter);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof WsdlPart) {
            WsdlPart wsdlPart = (WsdlPart)object;
            if (!this.getName().equals(wsdlPart.getName())) {
                return false;
            }
            return WsdlPartImpl.equalsWithNull(this.getElement(), wsdlPart.getElement()) && WsdlPartImpl.equalsWithNull(this.getType(), wsdlPart.getType());
        }
        return false;
    }

    private static boolean equalsWithNull(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return false;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("type", this.type);
        toStringWriter.writeField("element", this.element);
        toStringWriter.end();
    }
}

