/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;

public final class WsdlPortImpl
extends WsdlExtensibleImpl
implements WsdlPortBuilder {
    private QName name;
    private QName binding;
    private WsdlBindingBuilder wsdlBinding;
    private PolicyURIs policyUris;
    private final WsdlDefinitionsBuilder definitions;
    private final WsdlServiceBuilder service;
    private String transport;
    private WsdlAddressInfo.PortAddress portAddress;

    WsdlPortImpl(WsdlServiceBuilder wsdlServiceBuilder, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this.service = wsdlServiceBuilder;
        this.definitions = wsdlDefinitionsBuilder;
    }

    WsdlPortImpl(QName qName, WsdlServiceBuilder wsdlServiceBuilder, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this(wsdlServiceBuilder, wsdlDefinitionsBuilder);
        this.name = qName;
    }

    public QName getName() {
        return this.name;
    }

    public WsdlServiceBuilder getService() {
        return this.service;
    }

    public WsdlBindingBuilder getBinding() {
        if (this.wsdlBinding == null) {
            this.wsdlBinding = this.definitions.getBindings().get(this.binding);
        }
        return this.wsdlBinding;
    }

    public WsdlPortTypeBuilder getPortType() {
        return this.getBinding().getPortType();
    }

    public String getTransport() {
        if (this.transport == null) {
            this.transport = this.getBinding().getTransportProtocol();
        }
        return this.transport;
    }

    public void setTransport(String string) {
        this.transport = string;
    }

    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    public WsdlDefinitionsBuilder getDefinitions() {
        return this.definitions;
    }

    public void setBinding(QName qName) {
        this.binding = qName;
    }

    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
        return wsdlExtensionParser.parsePort(this, element);
    }

    protected void parseAttributes(Element element, String string) throws WsdlException {
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        String string3 = WsdlReader.getMustAttribute(element, null, "binding");
        this.binding = WsdlReader.createQName(element, string3);
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    public void setPortAddress(WsdlAddressInfo.PortAddress portAddress) {
        this.portAddress = portAddress;
    }

    public WsdlAddressInfo.PortAddress getPortAddress() {
        return this.portAddress;
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        wsdlWriter.setCurrentWsdlPort(this);
        Element element2 = wsdlWriter.addChild(element, "port", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        wsdlWriter.setAttribute(element2, "binding", WsdlConstants.wsdlNS, this.binding);
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        this.writeExtensions(element2, wsdlWriter);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("binding", this.binding);
        if (this.policyUris != null) {
            toStringWriter.writeField("policyUris", this.policyUris.toString());
        }
        toStringWriter.writeField("extensions", this.getExtensions());
        toStringWriter.end();
    }
}

