/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;
import weblogic.wsee.wsdl.internal.WsdlOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlPortTypeImpl
extends WsdlBase
implements WsdlPortTypeBuilder {
    private Map<QName, WsdlOperationBuilder> operationList = new LinkedHashMap<QName, WsdlOperationBuilder>();
    private QName name;
    private WsdlDefinitionsBuilder definitions;
    private PolicyURIs policyUris;

    WsdlPortTypeImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this.definitions = wsdlDefinitionsBuilder;
    }

    WsdlPortTypeImpl(QName qName, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        this(wsdlDefinitionsBuilder);
        this.name = qName;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Map<QName, WsdlOperationBuilder> getOperations() {
        return this.operationList;
    }

    public WsdlOperationBuilder getOperation(QName qName) {
        return this.operationList.get(qName);
    }

    @Override
    public WsdlOperationBuilder addOperation(QName qName) {
        WsdlOperationImpl wsdlOperationImpl = new WsdlOperationImpl(qName, this.definitions);
        this.operationList.put(qName, wsdlOperationImpl);
        return wsdlOperationImpl;
    }

    @Override
    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    @Override
    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    @Override
    public void parse(Element element, String string) throws WsdlException {
        this.addDocumentation(element);
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (WsdlReader.isWhiteSpace(node) || WsdlReader.isDocumentation(node)) continue;
            WsdlReader.checkDomElement(node);
            Element element2 = (Element)node;
            if (!WsdlReader.tagEquals(element2, "operation", WsdlConstants.wsdlNS)) continue;
            this.parseOperation(element2, string);
        }
    }

    private void parseOperation(Element element, String string) throws WsdlException {
        WsdlOperationImpl wsdlOperationImpl = new WsdlOperationImpl(this.definitions);
        wsdlOperationImpl.parse(element, string);
        this.operationList.put(wsdlOperationImpl.getName(), wsdlOperationImpl);
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        if (!wsdlWriter.isSameNS(this.getName().getNamespaceURI())) {
            return;
        }
        Element element2 = wsdlWriter.addChild(element, "portType", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        this.writeDocumentation(element2, wsdlWriter);
        for (WsdlOperationBuilder wsdlOperationBuilder : this.getOperations().values()) {
            wsdlOperationBuilder.write(element2, wsdlWriter);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeArray("operationList", this.operationList.values().iterator());
        toStringWriter.end();
    }
}

