/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.XmlException;
import com.bea.xml.XmlOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlSchemaImport;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlSchemaBuilder;
import weblogic.wsee.wsdl.builder.WsdlSchemaImportBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;
import weblogic.wsee.wsdl.internal.WsdlSchemaImportImpl;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlSchemaImpl
extends WsdlBase
implements WsdlSchemaBuilder {
    private SchemaDocument schema;
    private String locationUrl;
    private WsdlDefinitionsBuilder definitions;
    private List<WsdlSchemaImportBuilder> importList = new ArrayList<WsdlSchemaImportBuilder>();
    private TransportInfo transportInfo;

    WsdlSchemaImpl(TransportInfo transportInfo) {
        this.transportInfo = transportInfo;
    }

    WsdlSchemaImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, TransportInfo transportInfo) {
        this.definitions = wsdlDefinitionsBuilder;
        this.transportInfo = transportInfo;
    }

    WsdlSchemaImpl(SchemaDocument schemaDocument) {
        this.schema = schemaDocument;
    }

    @Override
    public SchemaDocument getSchema() {
        return this.schema;
    }

    @Override
    public WsdlDefinitionsBuilder getWsdlDefinitions() {
        return this.definitions;
    }

    @Override
    public String getLocationUrl() {
        return this.locationUrl;
    }

    @Override
    public List<WsdlSchemaImportBuilder> getImports() {
        return this.importList;
    }

    @Override
    public void parse(Element element, String string) throws WsdlException {
        this.parse(element, string, new HashSet<String>());
    }

    @Override
    public void parse(Element element, String string, Set<String> set) throws WsdlException {
        Object object;
        Object object2;
        try {
            object2 = new XmlOptions();
            this.locationUrl = string;
            object = string;
            if (object != null && ((String)object).startsWith("file:") && ((String)object).charAt(5) != '/') {
                object = "file:/" + string.substring(5);
            }
            object2.setDocumentSourceName((String)object);
            this.schema = SchemaDocument.Factory.parse((Node)element, (XmlOptions)object2);
        }
        catch (XmlException xmlException) {
            throw new WsdlException("Failed to parse schema", xmlException);
        }
        object2 = this.findImportAndIncludeNodes(element);
        object = object2.iterator();
        while (object.hasNext()) {
            Element element2 = (Element)object.next();
            WsdlSchemaImportImpl wsdlSchemaImportImpl = new WsdlSchemaImportImpl(this, this.transportInfo);
            wsdlSchemaImportImpl.parse(element2, set);
            if (wsdlSchemaImportImpl.getSchema() == null) continue;
            this.importList.add(wsdlSchemaImportImpl);
        }
    }

    public static WsdlSchema parse(String string) throws WsdlException {
        return WsdlSchemaImpl.parse(string, new HashSet<String>());
    }

    public static WsdlSchema parse(String string, Set<String> set) throws WsdlException {
        return WsdlSchemaImpl.parse(string, set, null);
    }

    public static WsdlSchemaBuilder parse(String string, Set<String> set, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) throws WsdlException {
        return WsdlSchemaImpl.parse(null, string, set, wsdlDefinitionsBuilder);
    }

    public static WsdlSchemaBuilder parse(TransportInfo transportInfo, String string, Set<String> set, WsdlDefinitionsBuilder wsdlDefinitionsBuilder) throws WsdlException {
        WsdlSchemaImpl wsdlSchemaImpl = new WsdlSchemaImpl(wsdlDefinitionsBuilder, transportInfo);
        Document document = WsdlReader.getDocument(transportInfo, string);
        wsdlSchemaImpl.parse(document.getDocumentElement(), string, set);
        return wsdlSchemaImpl;
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) throws WsdlException {
        Element element2 = this.getSchemaElement(wsdlWriter);
        Node node = element.getOwnerDocument().importNode(element2, true);
        element.appendChild(node);
    }

    @Override
    public void write(Document document, WsdlWriter wsdlWriter) throws WsdlException {
        Element element = this.getSchemaElement(wsdlWriter);
        Node node = document.importNode(element, true);
        document.appendChild(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(File file, String string) throws IOException, WsdlException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            Document document = this.toDocument(null);
            this.writeDocument(fileOutputStream, document, string);
            this.writeImportToFile(file, string);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static String validFilename(String string) {
        return string.replace('?', '_');
    }

    void writeImportToFile(File file, String string) throws IOException, WsdlException {
        File file2 = file.getCanonicalFile();
        for (WsdlSchemaImportBuilder wsdlSchemaImportBuilder : this.importList) {
            wsdlSchemaImportBuilder.writeToFile(file2, string);
        }
    }

    @Override
    public void write(OutputStream outputStream, WsdlAddressInfo wsdlAddressInfo, String string) throws IOException, WsdlException {
        Document document = this.toDocument(wsdlAddressInfo);
        this.writeDocument(outputStream, document, string);
    }

    private void writeDocument(OutputStream outputStream, Document document, String string) throws IOException {
        OutputFormat outputFormat = new OutputFormat("XML", string, true);
        XMLSerializer xMLSerializer = new XMLSerializer(outputStream, outputFormat);
        xMLSerializer.serialize(document);
    }

    @Override
    public void write(OutputStream outputStream, WsdlAddressInfo wsdlAddressInfo) throws IOException, WsdlException {
        this.write(outputStream, wsdlAddressInfo, null);
    }

    WsdlSchema findImport(String string) {
        for (WsdlSchemaImport wsdlSchemaImport : this.importList) {
            if (wsdlSchemaImport.isRelative() && string.equals(wsdlSchemaImport.getSchemaLocation())) {
                return wsdlSchemaImport.getSchema();
            }
            WsdlSchema wsdlSchema = ((WsdlSchemaImpl)wsdlSchemaImport.getSchema()).findImport(string);
            if (wsdlSchema == null) continue;
            return wsdlSchema;
        }
        return null;
    }

    private Document toDocument(WsdlAddressInfo wsdlAddressInfo) throws WsdlException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = WebLogicDocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            document = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WsdlException("Failed to create XML document", parserConfigurationException);
        }
        WsdlWriter wsdlWriter = new WsdlWriter();
        wsdlWriter.setWsdlAddressInfo(wsdlAddressInfo);
        this.write(document, wsdlWriter);
        return document;
    }

    private Element getSchemaElement(WsdlWriter wsdlWriter) {
        Element element = ((Document)this.schema.newDomNode()).getDocumentElement();
        if (wsdlWriter != null) {
            this.modifyRelativeImports(element, wsdlWriter);
        }
        return element;
    }

    private void modifyRelativeImports(Element element, WsdlWriter wsdlWriter) {
        List<Node> list = this.findImportAndIncludeNodes(element);
        for (Element element2 : list) {
            String string = element2.getAttribute("schemaLocation");
            if (string == null || "".equals(string) || !this.isRelative(string)) continue;
            string = WsdlSchemaImpl.validFilename(string);
            String string2 = wsdlWriter.getImportPrefix();
            if (string2 != null) {
                string = string2 + "/" + string;
            }
            element2.setAttribute("schemaLocation", string);
        }
    }

    private List<Node> findImportAndIncludeNodes(Element element) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !"http://www.w3.org/2001/XMLSchema".equals((element2 = (Element)nodeList.item(i)).getNamespaceURI()) || !"import".equals(element2.getLocalName()) && !"include".equals(element2.getLocalName()) && !"redefine".equals(element2.getLocalName())) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private boolean isRelative(String string) {
        try {
            new URL(string);
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            return true;
        }
    }
}

