/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.w3c.dom.Element;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlSchemaImport;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlSchemaBuilder;
import weblogic.wsee.wsdl.builder.WsdlSchemaImportBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;
import weblogic.wsee.wsdl.internal.WsdlSchemaImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlSchemaImportImpl
extends WsdlBase
implements WsdlSchemaImportBuilder {
    private static final boolean verbose = Verbose.isVerbose(WsdlSchemaImport.class);
    private WsdlSchemaBuilder schema;
    private WsdlSchemaBuilder parent;
    private String namespace;
    private String schemaLocation;
    private boolean relative;
    private boolean isInclude;
    private TransportInfo transportInfo;

    WsdlSchemaImportImpl(WsdlSchemaBuilder wsdlSchemaBuilder, TransportInfo transportInfo) {
        this.parent = wsdlSchemaBuilder;
        this.transportInfo = transportInfo;
    }

    @Override
    public WsdlSchemaBuilder getSchema() {
        return this.schema;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public void parse(Element element, Set<String> set) throws WsdlException {
        this.addDocumentation(element);
        this.namespace = element.getAttributeNS(null, "namespace");
        this.schemaLocation = element.getAttributeNS(null, "schemaLocation");
        this.isInclude = "include".equals(element.getNodeName());
        if (verbose) {
            Verbose.log("import/include namespace: " + this.namespace);
            Verbose.log("import/include schemaLocation: " + this.schemaLocation);
        }
        if (this.schemaLocation == null || "".equals(this.schemaLocation)) {
            this.relative = false;
            return;
        }
        String string = this.schemaLocation;
        try {
            URL uRL = new URL(this.schemaLocation);
            this.relative = false;
            if (uRL.getProtocol().equals("servicebus")) {
                string = WsdlUtils.constructRelativeLocation(this.schemaLocation, this.parent.getLocationUrl(), this.parent.getWsdlDefinitions() == null ? null : this.parent.getWsdlDefinitions().getRelativeResourceResolver());
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.relative = true;
            string = WsdlUtils.constructRelativeLocation(this.schemaLocation, this.parent.getLocationUrl(), this.parent.getWsdlDefinitions() == null ? null : this.parent.getWsdlDefinitions().getRelativeResourceResolver());
        }
        if (set.contains(string)) {
            if (verbose) {
                Verbose.log("Ignoring schema at " + this.schemaLocation + ": already processed");
            }
            return;
        }
        set.add(this.schemaLocation);
        set.add(string);
        this.schema = WsdlSchemaImpl.parse(this.transportInfo, string, set, this.parent.getWsdlDefinitions());
        element.setAttributeNS(null, "schemaLocation", this.schemaLocation);
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, this.isInclude ? "include" : "import", "http://www.w3.org/2001/XMLSchema");
        if (this.namespace != null) {
            wsdlWriter.setAttribute(element2, "namespace", "http://www.w3.org/2001/XMLSchema", this.namespace);
        }
        String string = wsdlWriter.getImportPrefix();
        if (this.isRelative() && string != null) {
            wsdlWriter.setAttribute(element2, "schemaLocation", "http://www.w3.org/2001/XMLSchema", string + "/" + this.schemaLocation);
        } else {
            wsdlWriter.setAttribute(element2, "schemaLocation", "http://www.w3.org/2001/XMLSchema", this.schemaLocation);
        }
    }

    @Override
    public void writeToFile(File file, String string) throws IOException, WsdlException {
        if (!this.relative) {
            return;
        }
        File file2 = new File(file.getParentFile(), this.schemaLocation);
        if (verbose) {
            Verbose.log("Writing schema import to file " + file2.getAbsolutePath());
        }
        this.schema.writeToFile(file2, string);
    }
}

