/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlExtensionRegistry;
import weblogic.wsee.wsdl.WsdlFilter;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.internal.DefaultWsdlFilter;
import weblogic.wsee.wsdl.internal.WsdlExtensibleImpl;
import weblogic.wsee.wsdl.internal.WsdlPortImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlServiceImpl
extends WsdlExtensibleImpl
implements WsdlServiceBuilder {
    private QName name;
    private WsdlDefinitionsBuilder definitions;
    private Map<QName, WsdlPortBuilder> portList = new LinkedHashMap<QName, WsdlPortBuilder>();
    private PolicyURIs policyUris;
    private WsdlFilter wsdlFilter = new DefaultWsdlFilter();

    WsdlServiceImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        assert (wsdlDefinitionsBuilder != null);
        this.definitions = wsdlDefinitionsBuilder;
    }

    WsdlServiceImpl(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName) {
        this(wsdlDefinitionsBuilder);
        this.name = qName;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public void setName(QName qName) {
        this.name = qName;
    }

    @Override
    public WsdlDefinitionsBuilder getDefinitions() {
        return this.definitions;
    }

    @Override
    public List<WsdlPortTypeBuilder> getPortTypes() {
        ArrayList<WsdlPortTypeBuilder> arrayList = new ArrayList<WsdlPortTypeBuilder>();
        for (WsdlPortBuilder wsdlPortBuilder : this.portList.values()) {
            WsdlBindingBuilder wsdlBindingBuilder = wsdlPortBuilder.getBinding();
            arrayList.add(wsdlBindingBuilder.getPortType());
        }
        return arrayList;
    }

    public WsdlPortBuilder getPort(QName qName) {
        return this.portList.get(qName);
    }

    @Override
    public Map<QName, WsdlPortBuilder> getPorts() {
        return this.portList;
    }

    @Override
    public PolicyURIs getPolicyUris() {
        return this.policyUris;
    }

    @Override
    public void setPolicyUris(PolicyURIs policyURIs) {
        this.policyUris = policyURIs;
    }

    @Override
    public WsdlPortBuilder addPort(QName qName, WsdlBinding wsdlBinding) {
        WsdlPortImpl wsdlPortImpl = new WsdlPortImpl(qName, this, this.definitions);
        wsdlPortImpl.setBinding(wsdlBinding.getName());
        this.portList.put(qName, wsdlPortImpl);
        return wsdlPortImpl;
    }

    @Override
    protected WsdlExtension parseChild(Element element, String string) throws WsdlException {
        if (WsdlReader.tagEquals(element, "port", WsdlConstants.wsdlNS)) {
            WsdlPortImpl wsdlPortImpl = new WsdlPortImpl(this, this.definitions);
            wsdlPortImpl.parse(element, string);
            this.portList.put(wsdlPortImpl.getName(), wsdlPortImpl);
            return null;
        }
        WsdlExtensionParser wsdlExtensionParser = WsdlExtensionRegistry.getParser();
        return wsdlExtensionParser.parseService(this, element);
    }

    @Override
    protected void parseAttributes(Element element, String string) throws WsdlException {
        String string2 = WsdlReader.getMustAttribute(element, null, "name");
        this.name = new QName(string, string2);
        PolicyURIs policyURIs = this.getPolicyUri(element);
        if (null != policyURIs) {
            this.policyUris = policyURIs;
        }
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) {
        if (!wsdlWriter.isSameNS(this.getName().getNamespaceURI())) {
            return;
        }
        Element element2 = wsdlWriter.addChild(element, "service", WsdlConstants.wsdlNS);
        wsdlWriter.setAttribute(element2, "name", WsdlConstants.wsdlNS, this.name.getLocalPart());
        if (this.policyUris != null) {
            this.policyUris.write(element2, wsdlWriter);
        }
        this.writeExtensions(element2, wsdlWriter);
        for (WsdlPortBuilder wsdlPortBuilder : this.getPorts().values()) {
            if (!this.wsdlFilter.isPortSupported(wsdlPortBuilder.getName())) continue;
            wsdlPortBuilder.write(element2, wsdlWriter);
        }
    }

    @Override
    public void setWsdlFilter(WsdlFilter wsdlFilter) {
        this.wsdlFilter = wsdlFilter;
    }

    @Override
    public WsdlFilter getWsdlFilter() {
        return this.wsdlFilter;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("portList", this.portList);
        toStringWriter.end();
    }
}

