/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.internal;

import com.bea.xbean.xb.xsdschema.SchemaDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlConstants;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlTypes;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlSchemaBuilder;
import weblogic.wsee.wsdl.builder.WsdlSchemaImportBuilder;
import weblogic.wsee.wsdl.builder.WsdlTypesBuilder;
import weblogic.wsee.wsdl.internal.WsdlBase;
import weblogic.wsee.wsdl.internal.WsdlSchemaImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTypesImpl
extends WsdlBase
implements WsdlTypesBuilder {
    private List<WsdlSchemaBuilder> schemas = new ArrayList<WsdlSchemaBuilder>();
    private static final boolean verbose = Verbose.isVerbose(WsdlTypes.class);
    HashMap parentNamespaceDefs = new HashMap();
    private String typesLocation;
    private TransportInfo transportInfo;

    WsdlTypesImpl(TransportInfo transportInfo) {
        this.transportInfo = transportInfo;
    }

    @Override
    public HashMap getNameSpaceDefs() {
        return this.parentNamespaceDefs;
    }

    @Override
    public SchemaDocument[] getSchemaArray() {
        ArrayList<WsdlSchemaBuilder> arrayList = new ArrayList<WsdlSchemaBuilder>();
        for (WsdlSchemaBuilder wsdlSchemaBuilder : this.schemas) {
            this.addSchemasToList(wsdlSchemaBuilder, arrayList);
        }
        return WsdlTypesImpl.schemaListToArray(arrayList);
    }

    @Override
    public List getNodeList() {
        SchemaDocument[] schemaDocumentArray = this.getSchemaArray();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < schemaDocumentArray.length; ++i) {
            Node node = schemaDocumentArray[i].getDomNode();
            if (node == null) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    @Override
    public List getNodeListWithoutImport() {
        SchemaDocument[] schemaDocumentArray = this.getSchemaArrayWithoutImport();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < schemaDocumentArray.length; ++i) {
            Node node = schemaDocumentArray[i].getDomNode();
            if (node == null) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private static SchemaDocument[] schemaListToArray(List<WsdlSchemaBuilder> list) {
        SchemaDocument[] schemaDocumentArray = new SchemaDocument[list.size()];
        int n = 0;
        for (WsdlSchemaBuilder wsdlSchemaBuilder : list) {
            schemaDocumentArray[n++] = wsdlSchemaBuilder.getSchema();
        }
        return schemaDocumentArray;
    }

    @Override
    public SchemaDocument[] getSchemaArrayWithoutImport() {
        return WsdlTypesImpl.schemaListToArray(this.schemas);
    }

    @Override
    public List<WsdlSchemaBuilder> getSchemaListWithoutImport() {
        return this.schemas;
    }

    private void addSchemasToList(WsdlSchemaBuilder wsdlSchemaBuilder, List<WsdlSchemaBuilder> list) {
        list.add(wsdlSchemaBuilder);
        List<WsdlSchemaImportBuilder> list2 = wsdlSchemaBuilder.getImports();
        for (WsdlSchemaImportBuilder wsdlSchemaImportBuilder : list2) {
            WsdlSchemaBuilder wsdlSchemaBuilder2 = wsdlSchemaImportBuilder.getSchema();
            if (this.isLoadedSchema(wsdlSchemaBuilder2, list)) continue;
            this.addSchemasToList(wsdlSchemaBuilder2, list);
        }
    }

    @Override
    public List<WsdlSchemaBuilder> getImportedWsdlSchemas() {
        ArrayList<WsdlSchemaBuilder> arrayList = new ArrayList<WsdlSchemaBuilder>();
        for (WsdlSchemaBuilder wsdlSchemaBuilder : this.schemas) {
            List<WsdlSchemaImportBuilder> list = wsdlSchemaBuilder.getImports();
            for (WsdlSchemaImportBuilder wsdlSchemaImportBuilder : list) {
                WsdlSchemaBuilder wsdlSchemaBuilder2 = wsdlSchemaImportBuilder.getSchema();
                if (this.isLoadedSchema(wsdlSchemaBuilder2, arrayList)) continue;
                this.addSchemasToList(wsdlSchemaBuilder2, arrayList);
            }
        }
        return arrayList;
    }

    private boolean isLoadedSchema(WsdlSchemaBuilder wsdlSchemaBuilder, List<WsdlSchemaBuilder> list) {
        for (WsdlSchemaBuilder wsdlSchemaBuilder2 : list) {
            if (!wsdlSchemaBuilder2.getLocationUrl().equals(wsdlSchemaBuilder.getLocationUrl())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parse(Element element, String string) throws WsdlException {
        this.addDocumentation(element);
        NodeList nodeList = element.getChildNodes();
        this.collectNamespaces(element, this.parentNamespaceDefs);
        if (verbose) {
            Verbose.log("Collected namespaces ...." + this.parentNamespaceDefs);
        }
        this.typesLocation = string;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (WsdlReader.isDocumentation(node) || !(node instanceof Element)) continue;
            this.setNamespaces((Element)node, this.parentNamespaceDefs);
            WsdlSchemaImpl wsdlSchemaImpl = new WsdlSchemaImpl(this.transportInfo);
            wsdlSchemaImpl.parse((Element)node, string);
            this.addSchema(wsdlSchemaImpl);
        }
    }

    private void setNamespaces(Element element, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (this.isDefined((String)entry.getKey(), element)) {
                if (!verbose) continue;
                Verbose.log("Namespace redefined -- " + entry.getKey());
                continue;
            }
            if ("".equals(entry.getKey())) {
                element.setAttribute("xmlns", (String)entry.getValue());
                continue;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry.getKey(), (String)entry.getValue());
        }
    }

    private boolean isDefined(String string, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (!"xmlns".equals(node.getPrefix()) || !node.getLocalName().equals(string)) continue;
            if (verbose) {
                Verbose.log("Namespace found:" + node.getLocalName());
            }
            return true;
        }
        return false;
    }

    private void collectNamespaces(Element element, Map map) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!"xmlns".equals(attr.getPrefix()) || map.containsKey(string = attr.getLocalName())) continue;
            map.put(string, attr.getValue());
        }
        Node node = element.getParentNode();
        if (node != null && node.getNodeType() == 1) {
            this.collectNamespaces((Element)node, map);
        }
    }

    @Override
    public void write(Element element, WsdlWriter wsdlWriter) throws WsdlException {
        Element element2 = wsdlWriter.addChild(element, "types", WsdlConstants.wsdlNS);
        this.writeDocumentation(element2, wsdlWriter);
        for (WsdlSchemaBuilder wsdlSchemaBuilder : this.schemas) {
            wsdlSchemaBuilder.write(element2, wsdlWriter);
        }
    }

    void writeImportToFile(File file, String string) throws IOException, WsdlException {
        for (WsdlSchemaImpl wsdlSchemaImpl : this.schemas) {
            wsdlSchemaImpl.writeImportToFile(file, string);
        }
    }

    @Override
    public void addSchemas(SchemaDocument[] schemaDocumentArray) throws WsdlException {
        for (SchemaDocument schemaDocument : schemaDocumentArray) {
            this.schemas.add(new WsdlSchemaImpl(schemaDocument));
        }
    }

    void addSchemaAsFirst(WsdlSchemaBuilder wsdlSchemaBuilder) {
        this.schemas.add(0, wsdlSchemaBuilder);
    }

    @Override
    public void addSchema(WsdlSchemaBuilder wsdlSchemaBuilder) {
        this.schemas.add(wsdlSchemaBuilder);
    }

    void addTypes(WsdlTypesImpl wsdlTypesImpl) {
        if (wsdlTypesImpl != null) {
            if (this.typesLocation != null && this.typesLocation.equals(wsdlTypesImpl.typesLocation)) {
                return;
            }
            this.schemas.addAll(wsdlTypesImpl.schemas);
        }
    }

    public WsdlSchema findImport(String string) {
        for (WsdlSchemaImpl wsdlSchemaImpl : this.schemas) {
            WsdlSchema wsdlSchema = wsdlSchemaImpl.findImport(string);
            if (wsdlSchema == null) continue;
            return wsdlSchema;
        }
        return null;
    }
}

