/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.schema;

import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlError;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTypeSystemGenerator {
    private static final String[] BASE_SCHEMA_NAMES = new String[]{"/weblogic/wsee/wsdl/schema/soap-encoding-11.xsd"};
    private static final List<SchemaDocument> BASE_SCHEMAS;
    private ArrayList<SchemaDocument> schemaList = new ArrayList();

    private SchemaTypeSystem compile(XmlObject[] xmlObjectArray) throws XmlException {
        return this.compile(xmlObjectArray, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem());
    }

    private SchemaTypeSystem compile(XmlObject[] xmlObjectArray, SchemaTypeLoader schemaTypeLoader) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        ArrayList arrayList = new ArrayList();
        xmlOptions.setErrorListener(arrayList);
        SchemaTypeSystem schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])xmlObjectArray, (SchemaTypeLoader)schemaTypeLoader, (XmlOptions)xmlOptions);
        for (XmlError xmlError : arrayList) {
            if (xmlError.getSeverity() != 0) continue;
            throw new XmlException(xmlError);
        }
        return schemaTypeSystem;
    }

    private SchemaTypeSystem getWsdlSchemaTypeSystem(ArrayList<SchemaDocument> arrayList) throws XmlException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (SchemaDocument schemaDocument : arrayList) {
            arrayList2.add(schemaDocument.getSchema().getTargetNamespace());
        }
        for (SchemaDocument schemaDocument : BASE_SCHEMAS) {
            if (arrayList2.contains(schemaDocument.getSchema().getTargetNamespace())) continue;
            arrayList.add(schemaDocument);
        }
        SchemaDocument[] schemaDocumentArray = arrayList.toArray(new SchemaDocument[arrayList.size()]);
        return this.compile((XmlObject[])schemaDocumentArray);
    }

    public void addSchemaDocuments(SchemaDocument[] schemaDocumentArray) {
        if (schemaDocumentArray != null) {
            List<SchemaDocument> list = Arrays.asList(schemaDocumentArray);
            this.schemaList.addAll(list);
        }
    }

    public void reset() {
        this.schemaList.clear();
    }

    public SchemaTypeSystem generate() throws XmlException {
        return this.getWsdlSchemaTypeSystem(this.schemaList);
    }

    static {
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>(BASE_SCHEMA_NAMES.length);
        for (String string : BASE_SCHEMA_NAMES) {
            try {
                InputStream inputStream = SchemaTypeSystemGenerator.class.getResourceAsStream(string);
                SchemaDocument schemaDocument = SchemaDocument.Factory.parse((InputStream)inputStream);
                arrayList.add(schemaDocument);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BASE_SCHEMAS = arrayList;
    }
}

