/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.soap11;

import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;

public class SoapAddress
implements WsdlExtension {
    public static final String KEY = "SOAP11-address";
    private String location;
    private static final boolean verbose = Verbose.isVerbose(SoapAddress.class);

    public SoapAddress(String string) {
        this.location = string;
    }

    protected SoapAddress() {
    }

    protected String getSOAPNS() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    public String getKey() {
        return KEY;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void parse(Element element, WsdlPort wsdlPort) throws WsdlException {
        this.location = WsdlReader.getAttribute(element, null, "location", true);
        int n = this.location.indexOf(":");
        if (wsdlPort instanceof WsdlPortBuilder) {
            WsdlPortBuilder wsdlPortBuilder = (WsdlPortBuilder)wsdlPort;
            if (n != -1) {
                wsdlPortBuilder.setTransport(this.location.substring(0, n));
            } else {
                wsdlPortBuilder.setTransport("http");
            }
        }
        if (verbose) {
            Verbose.log("Endpoint location :" + this.location);
        }
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "address", this.getSOAPNS());
        String string = wsdlWriter.getEndpointURL(this.location);
        if (string != null) {
            wsdlWriter.setAttribute(element2, "location", null, string);
        } else {
            wsdlWriter.setAttribute(element2, "location", null, this.location);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("location", this.location);
        toStringWriter.end();
    }

    public static SoapAddress attach(WsdlPort wsdlPort) {
        SoapAddress soapAddress = new SoapAddress();
        wsdlPort.putExtension(soapAddress);
        if (wsdlPort instanceof WsdlPortBuilder) {
            ((WsdlPortBuilder)wsdlPort).setTransport("http");
        }
        return soapAddress;
    }
}

