/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.soap11;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;

public class SoapBinding
implements WsdlExtension {
    public static final String KEY = "SOAP11";
    private String transport;
    private String style;
    protected static final Map knownProtocols = new HashMap();

    protected String getSOAPNS() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    public String getKey() {
        return KEY;
    }

    public String getStyle() {
        return this.style;
    }

    public String getTransportProtocol() {
        String string = (String)knownProtocols.get(this.transport);
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    public static SoapBinding narrow(WsdlBinding wsdlBinding) {
        return (SoapBinding)wsdlBinding.getExtension(KEY);
    }

    public static SoapBinding attach(WsdlBinding wsdlBinding) throws WsdlException {
        SoapBinding soapBinding = new SoapBinding();
        if (wsdlBinding instanceof WsdlBindingBuilder) {
            WsdlBindingBuilder wsdlBindingBuilder = (WsdlBindingBuilder)wsdlBinding;
            wsdlBindingBuilder.setBindingType(KEY);
            wsdlBindingBuilder.setTransportProtocol(soapBinding.getTransportProtocol());
        }
        wsdlBinding.putExtension(soapBinding);
        return soapBinding;
    }

    public void parse(Element element) throws WsdlException {
        this.transport = WsdlReader.getMustAttribute(element, null, "transport");
        String string = element.getAttribute("style");
        this.style = !StringUtil.isEmpty(string) ? string : "document";
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "binding", this.getSOAPNS());
        wsdlWriter.setAttribute(element2, "transport", null, this.transport);
        wsdlWriter.setAttribute(element2, "style", null, this.style);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("style", this.style);
        toStringWriter.writeField("transport", this.transport);
        toStringWriter.end();
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public void setTransport(String string) {
        this.transport = string;
    }

    public String getTransport() {
        return this.transport;
    }

    static {
        knownProtocols.put("http://schemas.xmlsoap.org/soap/http", "http");
        knownProtocols.put("http://schemas.xmlsoap.org/soap/https", "https");
        knownProtocols.put("http://www.openuri.org/2002/04/soap/jms/", "jms");
    }
}

