/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.soap11;

import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;

public class SoapBindingOperation
implements WsdlExtension {
    public static final String KEY = "SOAP11-binding-operation";
    private String style;
    private String soapAction;

    protected String getSOAPNS() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    public String getKey() {
        return KEY;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        if (!"rpc".equals(string) && !"document".equals(string)) {
            throw new IllegalArgumentException("Invalid soap binding style value:" + string);
        }
        this.style = string;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public static SoapBindingOperation narrow(WsdlBindingOperation wsdlBindingOperation) {
        return (SoapBindingOperation)wsdlBindingOperation.getExtension(KEY);
    }

    public void parse(Element element) {
        this.style = WsdlReader.getAttribute(element, null, "style");
        this.soapAction = WsdlReader.getAttribute(element, null, "soapAction", true);
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "operation", this.getSOAPNS());
        if (this.style != null) {
            wsdlWriter.setAttribute(element2, "style", null, this.style);
        }
        if (this.soapAction != null && !this.soapAction.trim().equals("")) {
            wsdlWriter.setAttribute(element2, "soapAction", null, this.soapAction);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("style", this.style);
        toStringWriter.writeField("soapAction", this.soapAction);
        toStringWriter.end();
    }

    public static SoapBindingOperation attach(WsdlBindingOperation wsdlBindingOperation) {
        SoapBindingOperation soapBindingOperation = new SoapBindingOperation();
        wsdlBindingOperation.putExtension(soapBindingOperation);
        return soapBindingOperation;
    }
}

