/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.soap11;

import java.util.List;
import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.mime.MimeMultipartRelated;
import weblogic.wsee.wsdl.mime.MimePart;
import weblogic.wsee.wsdl.soap11.SoapMessageBase;

public class SoapBody
extends SoapMessageBase
implements WsdlExtension {
    public static final String KEY = "SOAP11-body";
    private String parts;

    protected String getSOAPNS() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    public String getUse() {
        return this.use == null ? "literal" : this.use;
    }

    public String getParts() {
        return this.parts;
    }

    public void setParts(String string) {
        this.parts = string;
    }

    public String getKey() {
        return KEY;
    }

    public static SoapBody narrow(WsdlBindingMessage wsdlBindingMessage) {
        MimeMultipartRelated mimeMultipartRelated;
        SoapBody soapBody = (SoapBody)wsdlBindingMessage.getExtension(KEY);
        if (soapBody == null && (mimeMultipartRelated = MimeMultipartRelated.narrow(wsdlBindingMessage)) != null) {
            List<MimePart> list = mimeMultipartRelated.getParts();
            for (MimePart mimePart : list) {
                soapBody = SoapBody.narrow(mimePart);
                if (soapBody == null) continue;
                if (soapBody.getNamespace() != null) break;
                soapBody.setNamespace(wsdlBindingMessage.getBindingOperation().getName().getNamespaceURI());
                break;
            }
        }
        return soapBody;
    }

    public static SoapBody narrow(MimePart mimePart) {
        return (SoapBody)mimePart.getExtension(KEY);
    }

    public void parse(Element element) throws WsdlException {
        super.parse(element);
        this.parts = WsdlReader.getAttribute(element, null, "parts");
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "body", this.getSOAPNS());
        if (this.encodingStyle != null) {
            wsdlWriter.setAttribute(element2, "encodingStyle", null, this.encodingStyle);
        }
        if (this.use != null) {
            wsdlWriter.setAttribute(element2, "use", null, this.use);
        }
        if (this.namespace != null) {
            wsdlWriter.setAttribute(element2, "namespace", null, this.namespace);
        }
        if (this.parts != null) {
            wsdlWriter.setAttribute(element2, "parts", null, this.parts);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("encodingStyle", this.encodingStyle);
        toStringWriter.writeField("use", this.use);
        toStringWriter.writeField("namespace", this.namespace);
        toStringWriter.writeField("parts", this.parts);
        toStringWriter.end();
    }

    public static SoapBody attach(WsdlBindingMessage wsdlBindingMessage) {
        SoapBody soapBody = new SoapBody();
        wsdlBindingMessage.putExtension(soapBody);
        return soapBody;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }
}

