/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.soap11;

import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.soap11.SoapMessageBase;

public class SoapFault
extends SoapMessageBase
implements WsdlExtension {
    private static final String KEY = "SOAP11-fault";
    private String name;

    protected String getSOAPNS() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    public String getUse() {
        return this.use == null ? "literal" : this.use;
    }

    public String getKey() {
        return KEY;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void parse(Element element) throws WsdlException {
        super.parse(element);
        this.name = element.getAttribute("name");
        if (this.name == null) {
            Verbose.log("SOAP Fault name is null");
        }
    }

    public static SoapFault narrow(WsdlBindingMessage wsdlBindingMessage) {
        return (SoapFault)wsdlBindingMessage.getExtension(KEY);
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "fault", this.getSOAPNS());
        if (this.name != null) {
            element2.setAttribute("name", this.name);
        }
        if (this.encodingStyle != null) {
            wsdlWriter.setAttribute(element2, "encodingStyle", null, this.encodingStyle);
        }
        if (this.use != null) {
            wsdlWriter.setAttribute(element2, "use", null, this.use);
        }
        if (this.namespace != null) {
            wsdlWriter.setAttribute(element2, "namespace", null, this.namespace);
        }
    }

    public static SoapFault attach(WsdlBindingMessage wsdlBindingMessage) {
        SoapFault soapFault = new SoapFault();
        wsdlBindingMessage.putExtension(soapFault);
        return soapFault;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("name", this.name);
        toStringWriter.writeField("encodingStyle", this.encodingStyle);
        toStringWriter.writeField("use", this.use);
        toStringWriter.writeField("namespace", this.namespace);
        toStringWriter.end();
    }
}

