/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.soap11;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.wsee.wsdl.mime.MimePart;
import weblogic.wsee.wsdl.soap11.SoapMessageBase;

public class SoapHeader
extends SoapMessageBase
implements WsdlExtension {
    private static final String KEY = "SOAP11-header";
    private String part;
    private QName message;

    protected String getSOAPNS() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    public String getUse() {
        return this.use == null ? "literal" : this.use;
    }

    public String getKey() {
        return KEY;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String string) {
        this.part = string;
    }

    public QName getMessage() {
        return this.message;
    }

    public void setMessage(QName qName) {
        this.message = qName;
    }

    public void parse(Element element) throws WsdlException {
        super.parse(element);
        String string = WsdlReader.getMustAttribute(element, null, "message");
        this.message = WsdlReader.createQName(element, string);
        this.part = WsdlReader.getMustAttribute(element, null, "part");
    }

    public static SoapHeader narrow(WsdlBindingMessage wsdlBindingMessage) {
        return (SoapHeader)wsdlBindingMessage.getExtension(KEY);
    }

    public static SoapHeader narrow(MimePart mimePart) {
        return (SoapHeader)mimePart.getExtension(KEY);
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "header", this.getSOAPNS());
        wsdlWriter.setAttribute(element2, "message", null, this.message);
        wsdlWriter.setAttribute(element2, "part", null, this.part);
        if (this.use != null) {
            wsdlWriter.setAttribute(element2, "use", null, this.use);
        }
        if (this.encodingStyle != null) {
            wsdlWriter.setAttribute(element2, "encodingStyle", null, this.encodingStyle);
        }
    }

    public static SoapHeader attach(WsdlBindingMessage wsdlBindingMessage) {
        SoapHeader soapHeader = new SoapHeader();
        wsdlBindingMessage.putExtension(soapHeader);
        return soapHeader;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("message", this.message);
        toStringWriter.writeField("encodingStyle", this.encodingStyle);
        toStringWriter.writeField("use", this.use);
        toStringWriter.writeField("namespace", this.namespace);
        toStringWriter.writeField("parts", this.part);
        toStringWriter.end();
    }
}

