/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.validation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Properties;
import weblogic.wsee.util.Verbose;

public class BasicProfile11ErrorMessage {
    private static final boolean verbose = Verbose.isVerbose(BasicProfile11ErrorMessage.class);
    private String message;
    private String id;
    private static final String FILE = "weblogic/wsee/wsdl/validation/BasicProfile-1.1-2004-08-24.txt";
    private static SoftReference properties = new SoftReference<Object>(null);
    private String details;

    public BasicProfile11ErrorMessage(String string, String string2) {
        this.id = string;
        this.message = string2;
        this.details = this.getMessageFor(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n  -- WS-I Basic Profile 1.1 Validation Error --");
        stringBuffer.append("\n").append(this.message);
        stringBuffer.append("\n").append("Requirement ID: ").append(this.id);
        stringBuffer.append("\n").append(this.details);
        stringBuffer.append("\n Details here: ").append("http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html");
        return stringBuffer.toString();
    }

    private Properties getErrorMap() {
        Properties properties = (Properties)BasicProfile11ErrorMessage.properties.get();
        if (properties == null) {
            properties = this.load();
            BasicProfile11ErrorMessage.properties = new SoftReference<Properties>(properties);
        }
        return properties;
    }

    private String getMessageFor(String string) {
        Properties properties = this.getErrorMap();
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Not a valid Basic Profile 1.1 requirement ID: " + string);
        }
        return string2;
    }

    private Properties load() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(FILE);
        if (inputStream == null) {
            throw new AssertionError((Object)"Unable to find BasicProfile-1.1-2004-08-24.txt in classpath ");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)("Unable to load from stream: " + iOException));
        }
        return properties;
    }
}

