/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.validation;

import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.wsee.wsdl.validation.BasicProfile11ErrorMessage;
import weblogic.wsee.wsdl.validation.BasicProfile11ValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidator;

public class BasicProfile11Validator
implements WsdlValidator {
    private static final boolean verbose = Verbose.isVerbose(BasicProfile11Validator.class);

    public void validateDefinitions(WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
    }

    public void validateService(WsdlService wsdlService) throws WsdlValidationException {
    }

    public void validatePort(WsdlPort wsdlPort) throws WsdlValidationException {
    }

    public void validateBinding(WsdlBinding wsdlBinding) throws WsdlValidationException {
    }

    public void validateBindingOperation(WsdlBindingOperation wsdlBindingOperation) throws WsdlValidationException {
    }

    public void validateBindingMessage(WsdlBindingMessage wsdlBindingMessage) throws WsdlValidationException {
        SoapBody soapBody = SoapBody.narrow(wsdlBindingMessage);
        if (soapBody == null) {
            return;
        }
        if (!"literal".equals(soapBody.getUse())) {
            throw new BasicProfile11ValidationException(new BasicProfile11ErrorMessage("R2706", "Value of 'use' attribute in binding message '" + wsdlBindingMessage.getName() + "' in binding operation '" + wsdlBindingMessage.getBindingOperation().getName() + "' is not 'literal'"));
        }
    }

    public void validatePortType(WsdlPortType wsdlPortType) throws WsdlValidationException {
    }

    public void validateOperation(WsdlOperation wsdlOperation) throws WsdlValidationException {
    }

    public void validateMessage(WsdlMessage wsdlMessage) throws WsdlValidationException {
    }

    public void validatePart(WsdlPart wsdlPart) throws WsdlValidationException {
    }
}

