/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.validation;

import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlException;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlTypes;
import weblogic.wsee.wsdl.mime.MimeContent;
import weblogic.wsee.wsdl.mime.MimeMultipartRelated;
import weblogic.wsee.wsdl.mime.MimePart;
import weblogic.wsee.wsdl.mime.MimeXml;
import weblogic.wsee.wsdl.schema.SchemaTypeSystemGenerator;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.wsee.wsdl.soap11.SoapHeader;
import weblogic.wsee.wsdl.validation.WsdlValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidator;

public class PartsAndSchemaValidator
implements WsdlValidator {
    public void validateDefinitions(WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
        Object object;
        WsdlTypes wsdlTypes = wsdlDefinitions.getTypes();
        SchemaDocument[] schemaDocumentArray = wsdlTypes.getSchemaArray();
        SchemaTypeSystemGenerator schemaTypeSystemGenerator = new SchemaTypeSystemGenerator();
        schemaTypeSystemGenerator.addSchemaDocuments(schemaDocumentArray);
        SchemaTypeSystem schemaTypeSystem = null;
        try {
            schemaTypeSystem = schemaTypeSystemGenerator.generate();
        }
        catch (XmlException xmlException) {
            throw new WsdlValidationException("Impossible to compile the schemas", xmlException);
        }
        for (WsdlMessage wsdlExtensible : wsdlDefinitions.getMessages().values()) {
            for (WsdlPart wsdlPart : wsdlExtensible.getParts().values()) {
                SchemaType schemaType;
                SchemaType schemaType2;
                boolean bl = false;
                object = wsdlPart.getType();
                QName qName = wsdlPart.getElement();
                if (object != null) {
                    schemaType2 = schemaTypeSystem.findType((QName)object);
                    schemaType = XmlBeans.getBuiltinTypeSystem().findType((QName)object);
                    if (schemaType2 != null || schemaType != null) {
                        bl = true;
                    }
                } else if (qName != null) {
                    schemaType2 = schemaTypeSystem.findElement(qName);
                    schemaType = XmlBeans.getBuiltinTypeSystem().findElement(qName);
                    if (schemaType2 != null || schemaType != null) {
                        bl = true;
                    }
                } else {
                    throw new WsdlValidationException("No element or type specified for part'" + wsdlPart.getName() + "' in message '" + wsdlExtensible.getName() + "'");
                }
                if (bl) continue;
                throw new WsdlValidationException("The element or type specified for part'" + wsdlPart.getName() + "' in message '" + wsdlExtensible.getName() + "' cannot be found in any schemas referenced by this wsdl");
            }
        }
        for (WsdlBinding wsdlBinding : wsdlDefinitions.getBindings().values()) {
            for (WsdlBindingOperation wsdlBindingOperation : wsdlBinding.getOperations().values()) {
                WsdlBindingMessage wsdlBindingMessage = wsdlBindingOperation.getInput();
                object = wsdlBindingOperation.getOutput();
                if (wsdlBindingMessage != null) {
                    this.validateSoapHeaderMessage(wsdlBindingMessage, wsdlDefinitions);
                }
                if (object == null) continue;
                this.validateSoapHeaderMessage((WsdlBindingMessage)object, wsdlDefinitions);
            }
        }
    }

    private void validateSoapHeaderMessage(WsdlBindingMessage wsdlBindingMessage, WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
        MimeMultipartRelated mimeMultipartRelated;
        SoapHeader soapHeader = SoapHeader.narrow(wsdlBindingMessage);
        if (soapHeader != null) {
            this.validateSoapHeader(soapHeader, wsdlDefinitions);
        }
        if ((mimeMultipartRelated = MimeMultipartRelated.narrow(wsdlBindingMessage)) != null) {
            List<MimePart> list = mimeMultipartRelated.getParts();
            for (MimePart mimePart : list) {
                SoapHeader soapHeader2 = SoapHeader.narrow(mimePart);
                if (soapHeader2 == null) continue;
                this.validateSoapHeader(soapHeader2, wsdlDefinitions);
            }
        }
    }

    private void validateSoapHeader(SoapHeader soapHeader, WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
        QName qName = soapHeader.getMessage();
        if (qName == null) {
            throw new WsdlValidationException("The message attribute in the soap:header element must be specified");
        }
        WsdlMessage wsdlMessage = wsdlDefinitions.getMessages().get(qName);
        if (wsdlMessage == null) {
            throw new WsdlValidationException("The message '" + qName + "' specified in the soap:header cannot be found in the wsdl");
        }
        String string = soapHeader.getPart();
        WsdlPart wsdlPart = wsdlMessage.getParts().get(string);
        if (wsdlPart == null) {
            throw new WsdlValidationException("The part '" + string + "' specified in the soap-header for the message '" + qName + "' cannot be found");
        }
    }

    public void validateService(WsdlService wsdlService) throws WsdlValidationException {
    }

    public void validatePort(WsdlPort wsdlPort) throws WsdlValidationException {
    }

    public void validateBinding(WsdlBinding wsdlBinding) throws WsdlValidationException {
    }

    public void validateBindingOperation(WsdlBindingOperation wsdlBindingOperation) throws WsdlValidationException {
    }

    public void validateBindingMessage(WsdlBindingMessage wsdlBindingMessage) throws WsdlValidationException {
        MimeMultipartRelated mimeMultipartRelated = MimeMultipartRelated.narrow(wsdlBindingMessage);
        SoapBody soapBody = SoapBody.narrow(wsdlBindingMessage);
        MimeXml mimeXml = MimeXml.narrow(wsdlBindingMessage);
        List<MimeContent> list = MimeContent.narrow(wsdlBindingMessage);
        if (list != null) {
            for (MimeContent mimeContent : list) {
                this.validateMimeContent(wsdlBindingMessage, mimeContent);
            }
        }
        if (mimeXml != null) {
            this.validateMimeXml(wsdlBindingMessage, mimeXml);
        }
        if (soapBody != null) {
            this.validateSoapBody(wsdlBindingMessage, soapBody);
        }
        if (mimeMultipartRelated != null) {
            this.validateMultipartRelated(wsdlBindingMessage, mimeMultipartRelated);
        }
    }

    private void validateMultipartRelated(WsdlBindingMessage wsdlBindingMessage, MimeMultipartRelated mimeMultipartRelated) throws WsdlValidationException {
        List<MimePart> list = mimeMultipartRelated.getParts();
        for (MimePart mimePart : list) {
            this.validateMimePart(wsdlBindingMessage, mimePart);
        }
    }

    private void validateMimePart(WsdlBindingMessage wsdlBindingMessage, MimePart mimePart) throws WsdlValidationException {
        List<MimeContent> list = MimeContent.narrow(mimePart);
        MimeXml mimeXml = MimeXml.narrow(mimePart);
        SoapBody soapBody = SoapBody.narrow(mimePart);
        if (list != null) {
            for (MimeContent mimeContent : list) {
                this.validateMimeContent(wsdlBindingMessage, mimeContent);
            }
        }
        if (mimeXml != null) {
            this.validateMimeXml(wsdlBindingMessage, mimeXml);
        }
        if (soapBody != null) {
            this.validateSoapBody(wsdlBindingMessage, soapBody);
        }
    }

    private void validateSoapBody(WsdlBindingMessage wsdlBindingMessage, SoapBody soapBody) throws WsdlValidationException {
        String[] stringArray;
        String string = soapBody.getParts();
        if (string == null || string.equals("")) {
            return;
        }
        for (String string2 : stringArray = string.split(" ")) {
            this.validateMessagePartName(wsdlBindingMessage, string2);
        }
    }

    private void validateMimeXml(WsdlBindingMessage wsdlBindingMessage, MimeXml mimeXml) throws WsdlValidationException {
        String string = mimeXml.getPart();
        if (string != null && !string.equals("")) {
            this.validateMessagePartName(wsdlBindingMessage, string);
        }
    }

    private void validateMimeContent(WsdlBindingMessage wsdlBindingMessage, MimeContent mimeContent) throws WsdlValidationException {
        String string = mimeContent.getPart();
        if (string != null && !string.equals("")) {
            this.validateMessagePartName(wsdlBindingMessage, string);
        }
    }

    private void validateMessagePartName(WsdlBindingMessage wsdlBindingMessage, String string) throws WsdlValidationException {
        WsdlMessage wsdlMessage = null;
        try {
            wsdlMessage = wsdlBindingMessage.getMessage();
        }
        catch (Exception exception) {
            throw new WsdlValidationException("The message in the operation '" + wsdlBindingMessage.getBindingOperation().getName() + "' cannot be found");
        }
        WsdlPart wsdlPart = wsdlMessage.getParts().get(string);
        if (wsdlPart == null) {
            throw new WsdlValidationException("The part '" + string + "' specified in the binding '" + wsdlBindingMessage.getBindingOperation().getName() + "' for the message '" + wsdlMessage.getName() + "' cannot be found");
        }
    }

    public void validatePortType(WsdlPortType wsdlPortType) throws WsdlValidationException {
    }

    public void validateOperation(WsdlOperation wsdlOperation) throws WsdlValidationException {
    }

    public void validateMessage(WsdlMessage wsdlMessage) throws WsdlValidationException {
    }

    public void validatePart(WsdlPart wsdlPart) throws WsdlValidationException {
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

