/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.policy.deployment.PolicyReferenceWsdlExtension;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.validation.WsdlValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidator;

public class ReferenceValidator
implements WsdlValidator {
    private WsdlPolicySubject policySubject;

    public void validateDefinitions(WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
        this.policySubject = new WsdlPolicySubject(wsdlDefinitions);
    }

    public void validateService(WsdlService wsdlService) throws WsdlValidationException {
    }

    public void validatePort(WsdlPort wsdlPort) throws WsdlValidationException {
        if (wsdlPort.getBinding() == null) {
            throw new WsdlValidationException("Unable to find binding for port '" + wsdlPort.getName() + "'");
        }
        this.validatePolicyURIs(wsdlPort.getPolicyUris());
        this.validatePolicyReference(wsdlPort);
    }

    public void validateBinding(WsdlBinding wsdlBinding) throws WsdlValidationException {
        if (wsdlBinding.getPortType() == null) {
            throw new WsdlValidationException("Unable to find port type for binding '" + wsdlBinding.getName() + "'");
        }
        this.validatePolicyURIs(wsdlBinding.getPolicyUris());
        this.validatePolicyReference(wsdlBinding);
    }

    public void validateBindingOperation(WsdlBindingOperation wsdlBindingOperation) throws WsdlValidationException {
        QName qName = wsdlBindingOperation.getName();
        WsdlPortType wsdlPortType = wsdlBindingOperation.getBinding().getPortType();
        WsdlOperation wsdlOperation = wsdlPortType.getOperations().get(qName);
        if (wsdlOperation == null) {
            throw new WsdlValidationException("The operation '" + wsdlBindingOperation.getName() + "' defined in the binding '" + wsdlBindingOperation.getBinding().getName() + "' cannot be found in the portType '" + wsdlPortType.getName() + "'");
        }
        if (wsdlOperation.getInput() == null && wsdlBindingOperation.getInput() != null) {
            throw new WsdlValidationException("The operation '" + wsdlBindingOperation.getName() + "' has an input message defined in the binding '" + wsdlBindingOperation.getBinding().getName() + "' but not in the portType'" + wsdlPortType.getName() + "'");
        }
        if (wsdlOperation.getOutput() == null && wsdlBindingOperation.getOutput() != null) {
            throw new WsdlValidationException("The operation '" + wsdlBindingOperation.getName() + "' has an output message defined in the binding '" + wsdlBindingOperation.getBinding().getName() + "' but not in the portType'" + wsdlPortType.getName() + "'");
        }
        if (wsdlOperation.getInput() != null && wsdlBindingOperation.getInput() == null) {
            throw new WsdlValidationException("The operation '" + wsdlBindingOperation.getName() + "' has an input message defined in the portType'" + wsdlPortType.getName() + "' but not in the binding '" + wsdlBindingOperation.getBinding().getName() + "'");
        }
        if (wsdlOperation.getOutput() != null && wsdlBindingOperation.getOutput() == null) {
            throw new WsdlValidationException("The operation '" + wsdlBindingOperation.getName() + "' has an output message defined in the portType'" + wsdlPortType.getName() + "' but not in the binding '" + wsdlBindingOperation.getBinding().getName() + "'");
        }
    }

    public void validateBindingMessage(WsdlBindingMessage wsdlBindingMessage) throws WsdlValidationException {
        WsdlBindingMessage wsdlBindingMessage2;
        WsdlBindingOperation wsdlBindingOperation = wsdlBindingMessage.getBindingOperation();
        QName qName = wsdlBindingOperation.getName();
        WsdlPortType wsdlPortType = wsdlBindingOperation.getBinding().getPortType();
        try {
            if (wsdlBindingMessage.getMessage() == null) {
                throw new WsdlValidationException("One of the message [" + wsdlBindingMessage.getName() + "] for the operation '" + qName + "' defined in the portType '" + wsdlPortType.getName() + "' cannot be found in the WSDL");
            }
        }
        catch (WsdlException wsdlException) {
            throw new WsdlValidationException("One of the message [" + wsdlBindingMessage.getName() + "] for the operation '" + qName + "' defined in the portType '" + wsdlPortType.getName() + "' cannot be found in the WSDL");
        }
        this.validatePolicyURIs(wsdlBindingOperation.getPolicyUris());
        this.validatePolicyReference(wsdlBindingOperation);
        WsdlBindingMessage wsdlBindingMessage3 = wsdlBindingOperation.getInput();
        if (wsdlBindingMessage3 != null) {
            this.validatePolicyURIs(wsdlBindingMessage3.getPolicyUris());
            this.validatePolicyReference(wsdlBindingMessage3);
        }
        if ((wsdlBindingMessage2 = wsdlBindingOperation.getOutput()) != null) {
            this.validatePolicyURIs(wsdlBindingMessage2.getPolicyUris());
            this.validatePolicyReference(wsdlBindingMessage2);
        }
    }

    public void validatePortType(WsdlPortType wsdlPortType) throws WsdlValidationException {
        this.validatePolicyURIs(wsdlPortType.getPolicyUris());
    }

    public void validateOperation(WsdlOperation wsdlOperation) throws WsdlValidationException {
        this.validatePolicyURIs(wsdlOperation.getPolicyUris());
        this.validatePolicyReference(wsdlOperation);
        this.validatePolicyURIs(wsdlOperation.getInputPolicyUris());
        this.validatePolicyURIs(wsdlOperation.getOutputPolicyUris());
    }

    public void validateMessage(WsdlMessage wsdlMessage) throws WsdlValidationException {
        this.validatePolicyURIs(wsdlMessage.getPolicyUris());
        this.validatePolicyReference(wsdlMessage);
    }

    public void validatePart(WsdlPart wsdlPart) throws WsdlValidationException {
    }

    private void validatePolicyURIs(PolicyURIs policyURIs) throws WsdlValidationException {
        if (policyURIs != null) {
            for (URI uRI : policyURIs.getURIs()) {
                if (this.policySubject.policyExists(uRI)) continue;
                throw new WsdlValidationException("Can not resolve policy #" + uRI.getFragment());
            }
        }
    }

    private void validatePolicyReference(WsdlExtensible wsdlExtensible) throws WsdlValidationException {
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
        if (policyReferenceWsdlExtension != null) {
            ArrayList arrayList = policyReferenceWsdlExtension.getURIs();
            for (int i = 0; i < arrayList.size(); ++i) {
                URI uRI = (URI)arrayList.get(i);
                if (this.policySubject.policyExists(uRI)) continue;
                Set set = this.policySubject.getPolicies().keySet();
                String string = "Can not resolve policy #" + uRI.getFragment() + ".";
                if (set.isEmpty()) {
                    string = string + " No policies are attached to the wsdl.";
                } else {
                    Iterator iterator = set.iterator();
                    String string2 = "Existing policies are: ";
                    while (iterator.hasNext()) {
                        string2 = string2 + (String)iterator.next() + " ";
                    }
                    string = string + " Existing policies are: " + string2 + ".";
                }
                throw new WsdlValidationException(string);
            }
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

