/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.validation;

import java.util.ArrayList;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.validation.WsdlValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidator;

public final class ValidatorChain
implements WsdlValidator {
    private ArrayList chain = new ArrayList();

    public void add(WsdlValidator wsdlValidator) {
        this.checkValidator(wsdlValidator);
        this.chain.add(wsdlValidator);
    }

    public void add(int n, WsdlValidator wsdlValidator) {
        this.checkValidator(wsdlValidator);
        this.chain.add(n, wsdlValidator);
    }

    public int size() {
        return this.chain.size();
    }

    public void validateDefinitions(WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateDefinitions(wsdlDefinitions);
        }
    }

    public void validateService(WsdlService wsdlService) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateService(wsdlService);
        }
    }

    public void validatePort(WsdlPort wsdlPort) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validatePort(wsdlPort);
        }
    }

    public void validateBinding(WsdlBinding wsdlBinding) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateBinding(wsdlBinding);
        }
    }

    public void validateBindingOperation(WsdlBindingOperation wsdlBindingOperation) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateBindingOperation(wsdlBindingOperation);
        }
    }

    public void validateBindingMessage(WsdlBindingMessage wsdlBindingMessage) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateBindingMessage(wsdlBindingMessage);
        }
    }

    public void validatePortType(WsdlPortType wsdlPortType) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validatePortType(wsdlPortType);
        }
    }

    public void validateOperation(WsdlOperation wsdlOperation) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateOperation(wsdlOperation);
        }
    }

    public void validateMessage(WsdlMessage wsdlMessage) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validateMessage(wsdlMessage);
        }
    }

    public void validatePart(WsdlPart wsdlPart) throws WsdlValidationException {
        for (WsdlValidator wsdlValidator : this.chain) {
            wsdlValidator.validatePart(wsdlPart);
        }
    }

    private void checkValidator(WsdlValidator wsdlValidator) {
        if (wsdlValidator == null) {
            throw new IllegalArgumentException("validator can not be null");
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeArray("chain", this.chain.iterator());
        toStringWriter.end();
    }
}

