/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wsdl.validation;

import java.util.Iterator;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlElement;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.validation.PartsAndSchemaValidator;
import weblogic.wsee.wsdl.validation.ReferenceValidator;
import weblogic.wsee.wsdl.validation.ValidatorChain;
import weblogic.wsee.wsdl.validation.WsdlValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidator;

public class WsdlValidationRegistry {
    private static final WsdlValidationRegistry instance = new WsdlValidationRegistry();
    private ValidatorChain defaultValidator = this.createDefaultValidator();
    public static final WsdlValidator WSI_VALIDATOR = WsdlValidationRegistry.createWsiValidator();
    public static final WsdlValidator PARTS_SCHEMA_VALIDATOR = WsdlValidationRegistry.createPartsSchemaValidator();

    private WsdlValidationRegistry() {
    }

    public static WsdlValidationRegistry getInstance() {
        return instance;
    }

    public ValidatorChain getDefaultValidator() {
        return this.defaultValidator;
    }

    public void validate(WsdlDefinitions wsdlDefinitions) throws WsdlValidationException {
        this.validate(wsdlDefinitions, this.createDefaultValidator());
    }

    public void validate(WsdlDefinitions wsdlDefinitions, WsdlValidator wsdlValidator) throws WsdlValidationException {
        wsdlValidator.validateDefinitions(wsdlDefinitions);
        Iterator<WsdlElement> iterator = wsdlDefinitions.getMessages().values().iterator();
        while (iterator.hasNext()) {
            this.validateMessage(iterator.next(), wsdlValidator);
        }
        iterator = wsdlDefinitions.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            this.validatePortType((WsdlPortType)iterator.next(), wsdlValidator);
        }
        iterator = wsdlDefinitions.getBindings().values().iterator();
        while (iterator.hasNext()) {
            this.validateBinding((WsdlBinding)iterator.next(), wsdlValidator);
        }
        iterator = wsdlDefinitions.getServices().values().iterator();
        while (iterator.hasNext()) {
            this.validateService((WsdlService)iterator.next(), wsdlValidator);
        }
    }

    private void validatePortType(WsdlPortType wsdlPortType, WsdlValidator wsdlValidator) throws WsdlValidationException {
        wsdlValidator.validatePortType(wsdlPortType);
        Iterator<? extends WsdlOperation> iterator = wsdlPortType.getOperations().values().iterator();
        while (iterator.hasNext()) {
            wsdlValidator.validateOperation(iterator.next());
        }
    }

    private void validateMessage(WsdlMessage wsdlMessage, WsdlValidator wsdlValidator) throws WsdlValidationException {
        wsdlValidator.validateMessage(wsdlMessage);
        Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
        while (iterator.hasNext()) {
            wsdlValidator.validatePart(iterator.next());
        }
    }

    private void validateBinding(WsdlBinding wsdlBinding, WsdlValidator wsdlValidator) throws WsdlValidationException {
        wsdlValidator.validateBinding(wsdlBinding);
        for (WsdlBindingOperation wsdlBindingOperation : wsdlBinding.getOperations().values()) {
            this.validateBindingOperation(wsdlBindingOperation, wsdlValidator);
        }
    }

    private void validateBindingOperation(WsdlBindingOperation wsdlBindingOperation, WsdlValidator wsdlValidator) throws WsdlValidationException {
        wsdlValidator.validateBindingOperation(wsdlBindingOperation);
        if (wsdlBindingOperation.getInput() != null) {
            wsdlValidator.validateBindingMessage(wsdlBindingOperation.getInput());
        }
        if (wsdlBindingOperation.getOutput() != null) {
            wsdlValidator.validateBindingMessage(wsdlBindingOperation.getOutput());
        }
        for (WsdlBindingMessage wsdlBindingMessage : wsdlBindingOperation.getFaults().values()) {
            wsdlValidator.validateBindingMessage(wsdlBindingMessage);
        }
    }

    private void validateService(WsdlService wsdlService, WsdlValidator wsdlValidator) throws WsdlValidationException {
        wsdlValidator.validateService(wsdlService);
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            wsdlValidator.validatePort(wsdlPort);
        }
    }

    private static WsdlValidator createWsiValidator() {
        return new ValidatorChain();
    }

    private static WsdlValidator createPartsSchemaValidator() {
        ValidatorChain validatorChain = new ValidatorChain();
        validatorChain.add(new ReferenceValidator());
        validatorChain.add(new PartsAndSchemaValidator());
        return validatorChain;
    }

    private ValidatorChain createDefaultValidator() {
        ValidatorChain validatorChain = new ValidatorChain();
        validatorChain.add(new ReferenceValidator());
        return validatorChain;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

