/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.store.PersistentHandle;
import weblogic.transaction.XIDFactory;
import weblogic.wsee.wstx.internal.BranchXidImpl;
import weblogic.wsee.wstx.internal.JTAHelper;
import weblogic.wsee.wstx.wsat.WSATHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchRecord
implements Externalizable {
    private static final long serialVersionUID = -8663994789749988958L;
    private static final int VERSION = 1;
    private Xid globalXid;
    private List<RegisteredResource> registeredResources;
    private boolean isPrimaryBranchCompleted = false;
    private String branchAliasSuffix = "BI_WSATGatewayRM";
    private PersistentHandle storeHandle;
    private boolean logged;

    public BranchRecord() {
        this.registeredResources = new ArrayList<RegisteredResource>();
    }

    BranchRecord(Xid xid) {
        this.globalXid = xid;
        this.registeredResources = new ArrayList<RegisteredResource>();
    }

    public synchronized RegisteredResource addSubordinate(XAResource xAResource) {
        RegisteredResource registeredResource = new RegisteredResource(xAResource);
        this.registeredResources.add(registeredResource);
        return registeredResource;
    }

    synchronized String getBranchName(XAResource xAResource) {
        int n = this.getResourceIndex(xAResource);
        if (n == -1) {
            throw new IllegalStateException("WS-AT resource not associated with transaction branch " + this.globalXid);
        }
        return n + this.branchAliasSuffix;
    }

    void setStoreHandle(PersistentHandle persistentHandle) {
        this.storeHandle = persistentHandle;
    }

    PersistentHandle getStoreHandle() {
        return this.storeHandle;
    }

    void setLogged(boolean bl) {
        this.logged = bl;
    }

    boolean isLogged() {
        return this.logged;
    }

    int prepare(Xid xid) throws XAException {
        if (this.isPrimaryBranch(xid)) {
            this.debug("prepare() xid=" + xid + " returning XA_OK");
            return 0;
        }
        RegisteredResource registeredResource = this.getRegisteredResource(xid);
        int n = 0;
        try {
            n = registeredResource.prepare(xid);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 100: {
                    throw xAException;
                }
                case -4: {
                    JTAHelper.throwXAException(106, "Subordinate resource timeout.", xAException);
                    break;
                }
                default: {
                    throw xAException;
                }
            }
        }
        return n;
    }

    void rollback(Xid xid) throws XAException {
        if (this.isPrimaryBranch(xid)) {
            this.debug("rollback() xid=" + xid + " ignoring primary branch ");
        }
        RegisteredResource registeredResource = this.getRegisteredResource(xid);
        try {
            registeredResource.rollback(xid);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 5: 
                case 7: 
                case 8: {
                    throw xAException;
                }
                case -4: {
                    break;
                }
                default: {
                    throw xAException;
                }
            }
        }
    }

    void commit(Xid xid, boolean bl) throws XAException {
        if (this.isPrimaryBranch(xid)) {
            this.debug("commit() xid=" + xid + " setting primary branch as completed");
            this.isPrimaryBranchCompleted = true;
            return;
        }
        RegisteredResource registeredResource = this.getRegisteredResource(xid);
        try {
            registeredResource.commit(xid, bl);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 5: 
                case 6: 
                case 8: {
                    throw xAException;
                }
                case -4: {
                    break;
                }
                default: {
                    throw xAException;
                }
            }
        }
    }

    private synchronized int getResourceIndex(XAResource xAResource) {
        for (int i = 0; i < this.registeredResources.size(); ++i) {
            RegisteredResource registeredResource = this.registeredResources.get(i);
            if (!xAResource.equals(registeredResource.resource)) continue;
            return i;
        }
        return -1;
    }

    XAResource exists(XAResource xAResource) {
        int n = this.getResourceIndex(xAResource);
        return n == -1 ? null : this.registeredResources.get(n).resource;
    }

    boolean isPrimaryBranch(Xid xid) {
        return Arrays.equals(xid.getBranchQualifier(), this.globalXid.getBranchQualifier());
    }

    private int getResourceIndex(Xid xid) {
        String string = new String(xid.getBranchQualifier());
        int n = string.indexOf(this.branchAliasSuffix);
        if (n == -1) {
            return -1;
        }
        String string2 = string.substring(0, n);
        int n2 = Integer.parseInt(string2);
        return n2;
    }

    private synchronized RegisteredResource getRegisteredResource(Xid xid) throws XAException {
        boolean bl;
        RegisteredResource registeredResource;
        int n = this.getResourceIndex(xid);
        if (n == -1) {
            JTAHelper.throwXAException(-4, "This may be expected during rollback if client and web service are collocated, Xid=" + xid);
        }
        if ((registeredResource = this.registeredResources.get(n)) == null) {
            JTAHelper.throwXAException(-4, "Xid=" + xid);
        }
        if (registeredResource.getBranchXid() != null && !(bl = Arrays.equals(registeredResource.getBranchXid().getBranchQualifier(), xid.getBranchQualifier()))) {
            WSATHelper.getInstance();
            if (WSATHelper.isDebugEnabled()) {
                byte[] byArray = registeredResource.getBranchXid().getBranchQualifier();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                WSATHelper.getInstance().debug("WSAT Branch registered branchId:\t[" + new String(byArray) + "] ");
                byArray = xid.getBranchQualifier();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                WSATHelper.getInstance().debug("WSAT Branch branchId used to identify a registered resource:\t[" + new String(byArray) + "] ");
            }
            this.debug("prepare() xid=" + xid + " returning XA_RDONLY");
            JTAHelper.throwXAException(-4, "xid=" + xid);
        }
        return registeredResource;
    }

    Xid getXid() {
        return this.globalXid;
    }

    synchronized Collection<Xid> getAllXids() {
        ArrayList<Xid> arrayList = new ArrayList<Xid>();
        for (int i = 0; i < this.registeredResources.size(); ++i) {
            arrayList.add(this.registeredResources.get(i).getBranchXid());
        }
        return arrayList;
    }

    void assignBranchXid(Xid xid) {
        int n = this.getResourceIndex(xid);
        if (n == -1) {
            return;
        }
        RegisteredResource registeredResource = this.registeredResources.get(n);
        if (registeredResource == null) {
            return;
        }
        if (registeredResource.getBranchXid() == null) {
            registeredResource.setBranchXid(xid);
        }
    }

    synchronized boolean allResourcesCompleted() {
        if (!this.isPrimaryBranchCompleted) {
            return false;
        }
        int n = this.registeredResources.size();
        for (int i = 0; i < n; ++i) {
            RegisteredResource registeredResource = this.registeredResources.get(i);
            if (registeredResource.isCompleted()) continue;
            return false;
        }
        return true;
    }

    private void debug(String string) {
        WSATHelper.getInstance();
        if (WSATHelper.isDebugEnabled()) {
            WSATHelper.getInstance().debug("[WSAT Branch " + this.globalXid + "] " + string);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeInt(this.globalXid.getFormatId());
        byte[] byArray = this.globalXid.getGlobalTransactionId();
        objectOutput.writeByte((byte)byArray.length);
        objectOutput.write(byArray);
        byte[] byArray2 = this.globalXid.getBranchQualifier();
        if (byArray2 == null) {
            objectOutput.writeByte(-1);
        } else {
            objectOutput.writeByte((byte)byArray2.length);
            objectOutput.write(byArray2);
        }
        objectOutput.writeInt(this.registeredResources.size());
        for (int i = 0; i < this.registeredResources.size(); ++i) {
            RegisteredResource registeredResource = this.registeredResources.get(i);
            registeredResource.writeExternal(objectOutput);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n != 1) {
            throw new IOException("invalid OTSBranch version " + n);
        }
        int n2 = objectInput.readInt();
        byte by = objectInput.readByte();
        byte[] byArray = new byte[by];
        objectInput.readFully(byArray);
        by = objectInput.readByte();
        byte[] byArray2 = null;
        if (by > -1) {
            byArray2 = new byte[by];
            objectInput.readFully(byArray2);
        }
        this.globalXid = XIDFactory.createXID((int)n2, (byte[])byArray, (byte[])byArray2);
        int n3 = objectInput.readInt();
        for (int i = 0; i < n3; ++i) {
            RegisteredResource registeredResource = new RegisteredResource();
            registeredResource.readExternal(objectInput);
            registeredResource.setPrepared();
            this.registeredResources.add(registeredResource);
        }
        this.logged = true;
    }

    public String toString() {
        return "BranchRecord:globalXid=" + this.globalXid;
    }

    class RegisteredResource
    implements Externalizable {
        private static final long serialVersionUID = 601688150453719976L;
        private static final int STATE_ACTIVE = 1;
        private static final int STATE_PREPARED = 2;
        private static final int STATE_READONLY = 3;
        private static final int STATE_COMPLETED = 4;
        private XAResource resource;
        private int vote = -1;
        private int state;
        private BranchXidImpl branchXid;

        RegisteredResource() {
        }

        RegisteredResource(XAResource xAResource) {
            this.resource = xAResource;
            this.state = 1;
        }

        private Xid getBranchXid() {
            if (this.branchXid == null) {
                return null;
            }
            return this.branchXid.getDelegate();
        }

        private void setBranchXid(Xid xid) {
            this.branchXid = new BranchXidImpl(xid);
        }

        private void setPrepared() {
            this.state = 2;
        }

        XAResource getResource() {
            return this.resource;
        }

        boolean isCompleted() {
            return this.state == 4 || this.state == 3;
        }

        int prepare(Xid xid) throws XAException {
            switch (this.state) {
                case 2: 
                case 3: {
                    return this.vote;
                }
                case 4: {
                    JTAHelper.throwXAException(-5, "Resource completed.");
                }
            }
            try {
                this.vote = this.resource.prepare(xid);
                switch (this.vote) {
                    case 0: {
                        this.state = 2;
                        break;
                    }
                    case 3: {
                        this.state = 3;
                    }
                }
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        this.state = 4;
                        throw xAException;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        throw xAException;
                    }
                }
                throw xAException;
            }
            return this.vote;
        }

        void commit(Xid xid, boolean bl) throws XAException {
            switch (this.state) {
                case 3: 
                case 4: {
                    return;
                }
            }
            try {
                this.resource.commit(xid, bl);
                this.state = 4;
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 7: {
                        this.state = 4;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.state = 4;
                        throw xAException;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        if (bl) {
                            this.state = 4;
                            throw xAException;
                        }
                        JTAHelper.throwXAException(8, "Invalid rollback error code thrown for 2PC commit. ", xAException);
                        break;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -3: {
                        throw xAException;
                    }
                    case -4: {
                        this.state = 4;
                        break;
                    }
                    default: {
                        throw xAException;
                    }
                }
            }
        }

        void rollback(Xid xid) throws XAException {
            switch (this.state) {
                case 3: 
                case 4: {
                    return;
                }
            }
            try {
                this.resource.rollback(xid);
                this.state = 4;
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 6: {
                        this.state = 4;
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.state = 4;
                        throw xAException;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -3: {
                        throw xAException;
                    }
                    case -4: {
                        this.state = 4;
                        break;
                    }
                    default: {
                        throw xAException;
                    }
                }
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.branchXid = new BranchXidImpl();
            this.branchXid.readExternal(objectInput);
            this.resource = (XAResource)objectInput.readObject();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            this.branchXid.writeExternal(objectOutput);
            objectOutput.writeObject(this.resource);
        }
    }
}

