/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.wsee.wstx.internal.ForeignRecoveryContextManager;
import weblogic.wsee.wstx.wsat.Transactional;

public class ForeignRecoveryContext
implements Externalizable {
    private static final long serialVersionUID = -3257083889097518770L;
    private static int klassVersion = 1032;
    private Xid fxid;
    private Transactional.Version version;
    private EndpointReference epr;

    public ForeignRecoveryContext() {
    }

    ForeignRecoveryContext(Xid xid) {
        this.fxid = xid;
    }

    public void setEndpointReference(EndpointReference endpointReference, Transactional.Version version2) {
        this.epr = endpointReference;
        this.version = version2;
    }

    public Xid getXid() {
        return this.fxid;
    }

    public EndpointReference getEndpointReference() {
        return this.epr;
    }

    Transactional.Version getVersion() {
        return this.version;
    }

    Transaction getTransaction() {
        if (this.fxid == null) {
            throw new AssertionError((Object)("No Tid to Xid mapping for " + this));
        }
        return ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).getTransaction(this.fxid);
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        klassVersion = objectInput.readInt();
        this.fxid = (Xid)objectInput.readObject();
        this.debug("ForeignRecoveryContext.readExternal tid:" + this.fxid);
        this.version = (Transactional.Version)objectInput.readObject();
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        this.epr = EndpointReference.readFrom((Source)new StreamSource(new ByteArrayInputStream(byArray)));
        this.debug("ForeignRecoveryContext.readExternal EndpointReference:" + this.epr);
        ForeignRecoveryContextManager.getInstance().add(this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(klassVersion);
        objectOutput.writeObject(this.fxid);
        objectOutput.writeObject(this.version);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.epr.writeTo((Result)new StreamResult(byteArrayOutputStream));
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public String toString() {
        return "ForeignRecoveryContext[tid=" + this.fxid + ", endPointreference=" + this.epr + ", version = " + this.version + "]";
    }

    private void debug(String string) {
        if (ForeignRecoveryContextManager.getInstance().debugWSAT.isDebugEnabled()) {
            ForeignRecoveryContextManager.getInstance().debugWSAT.debug(this + " " + string);
        }
    }
}

