/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.wstx.internal.ForeignRecoveryContext;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.common.CoordinatorIF;
import weblogic.wsee.wstx.wsat.common.WSATVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignRecoveryContextManager {
    private static final int REPLAY_TIMER_INTERVAL_MS = new Integer(System.getProperty("wsee.wstx.wsat.indoubt.timeout.interval", "10000"));
    private static final int INDOUBT_TIMEOUT = new Integer(System.getProperty("wsee.wstx.wsat.indoubt.timeout", "90000"));
    private static ForeignRecoveryContextManager singleton = new ForeignRecoveryContextManager();
    final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private TimerManager timerManager;
    private WorkManager workManager;
    private Map<Xid, RecoveryContextWorker> recoveredContexts = new HashMap<Xid, RecoveryContextWorker>();

    private ForeignRecoveryContextManager() {
    }

    public static ForeignRecoveryContextManager getInstance() {
        return singleton;
    }

    public synchronized ForeignRecoveryContext addAndGetForeignRecoveryContextForTidByteArray(Xid xid) {
        RecoveryContextWorker recoveryContextWorker = this.recoveredContexts.get(xid);
        if (recoveryContextWorker != null) {
            return recoveryContextWorker.context;
        }
        ForeignRecoveryContext foreignRecoveryContext = new ForeignRecoveryContext(xid);
        this.add(foreignRecoveryContext, false);
        return foreignRecoveryContext;
    }

    void start() {
        this.workManager = WorkManagerFactory.getInstance().getSystem();
        if (this.workManager == null) {
            throw new AssertionError((Object)"WorkManager not initialized");
        }
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
        if (this.timerManager == null) {
            throw new AssertionError((Object)"TimerManager not initialized");
        }
        this.timerManager.schedule((TimerListener)new ContextTimerListener(), (long)REPLAY_TIMER_INTERVAL_MS, (long)REPLAY_TIMER_INTERVAL_MS);
    }

    synchronized void add(ForeignRecoveryContext foreignRecoveryContext) {
        this.add(foreignRecoveryContext, true);
    }

    synchronized void add(ForeignRecoveryContext foreignRecoveryContext, boolean bl) {
        this.recoveredContexts.put(foreignRecoveryContext.getXid(), new RecoveryContextWorker(foreignRecoveryContext, bl ? -1 : 0));
    }

    Map<Xid, RecoveryContextWorker> getRecoveredContexts() {
        return this.recoveredContexts;
    }

    synchronized void remove(Xid xid) {
        this.recoveredContexts.remove(xid);
    }

    private class RecoveryContextWorker
    extends WorkAdapter {
        final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");
        ForeignRecoveryContext context;
        long lastReplayMillis;
        boolean scheduled;
        private int retryCount = 1;

        RecoveryContextWorker(ForeignRecoveryContext foreignRecoveryContext, int n) {
            this.context = foreignRecoveryContext;
            this.lastReplayMillis = n;
        }

        synchronized long getLastReplayMillis() {
            return this.lastReplayMillis;
        }

        synchronized void setLastReplayMillis(long l) {
            this.lastReplayMillis = l;
        }

        synchronized boolean isScheduled() {
            return this.scheduled;
        }

        synchronized void setScheduled(boolean bl) {
            this.scheduled = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.context.getXid();
                if (object == null) {
                    if (this.debugWSAT.isDebugEnabled()) {
                        this.debugWSAT.debug("no Xid mapping for recovered context " + this.context);
                    }
                    return;
                }
                if (this.debugWSAT.isDebugEnabled()) {
                    this.debugWSAT.debug("about to send Prepared recovery call for " + this.context);
                }
                CoordinatorIF coordinatorIF = WSATHelper.getInstance(this.context.getVersion()).getCoordinatorPort(this.context.getEndpointReference(), (Xid)object);
                if (this.debugWSAT.isDebugEnabled()) {
                    this.debugWSAT.debug("About to send Prepared recovery call for " + this.context + " with coordinatorPort:" + coordinatorIF);
                }
                Object t = WSATVersion.getInstance(this.context.getVersion()).newNotificationBuilder().build();
                Transaction transaction = this.context.getTransaction();
                if (transaction != null && transaction.getStatus() == 2) {
                    coordinatorIF.preparedOperation(t);
                }
                if (this.debugWSAT.isDebugEnabled()) {
                    this.debugWSAT.debug("Prepared recovery call for " + this.context + " returned successfully");
                }
            }
            catch (Throwable throwable) {
                this.debugWSAT.debug("Prepared recovery call error for " + this.context, throwable);
            }
            finally {
                RecoveryContextWorker recoveryContextWorker = this;
                synchronized (recoveryContextWorker) {
                    this.scheduled = false;
                    this.lastReplayMillis = System.currentTimeMillis();
                }
            }
        }

        void incrementRetryCount() {
            if (this.retryCount * 2 * INDOUBT_TIMEOUT < 0x2AAAAAAA) {
                this.retryCount *= 2;
            }
            if (this.debugWSAT.isDebugEnabled()) {
                this.debugWSAT.debug("Next recovery call for " + this.context + " in:" + this.retryCount * INDOUBT_TIMEOUT);
            }
        }

        int getRetryCount() {
            return this.retryCount;
        }
    }

    private class ContextTimerListener
    implements TimerListener {
        private ContextTimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            ArrayList<RecoveryContextWorker> arrayList = new ArrayList<RecoveryContextWorker>();
            ForeignRecoveryContextManager foreignRecoveryContextManager = ForeignRecoveryContextManager.this;
            synchronized (foreignRecoveryContextManager) {
                for (RecoveryContextWorker recoveryContextWorker : ForeignRecoveryContextManager.this.recoveredContexts.values()) {
                    long l = recoveryContextWorker.getLastReplayMillis();
                    if (l == -1L) {
                        arrayList.add(recoveryContextWorker);
                        continue;
                    }
                    try {
                        Transaction transaction = recoveryContextWorker.context.getTransaction();
                        if (transaction == null || transaction.getStatus() != 2) continue;
                        if (l == 0L) {
                            recoveryContextWorker.setLastReplayMillis(System.currentTimeMillis());
                        }
                        arrayList.add(recoveryContextWorker);
                    }
                    catch (Throwable throwable) {
                        ForeignRecoveryContextManager.this.debugWSAT.debug("ForeignRecoveryContextManager$ContextTimerListener.timerExpired error scheduling work for recovery context:" + recoveryContextWorker.context + " Exception getting transaction status, transaction may be null:" + throwable);
                    }
                }
            }
            if (ForeignRecoveryContextManager.this.debugWSAT.isDebugEnabled() && !arrayList.isEmpty()) {
                ForeignRecoveryContextManager.this.debugWSAT.debug("ForeignRecoveryContextManager$ContextTimerListener.timerExpired replayList.size():" + arrayList.size());
            }
            for (RecoveryContextWorker recoveryContextWorker : arrayList) {
                boolean bl = recoveryContextWorker.isScheduled();
                if (bl || System.currentTimeMillis() - recoveryContextWorker.getLastReplayMillis() <= (long)(INDOUBT_TIMEOUT * recoveryContextWorker.getRetryCount())) continue;
                recoveryContextWorker.setScheduled(true);
                recoveryContextWorker.incrementRetryCount();
                ForeignRecoveryContextManager.this.workManager.schedule((Runnable)((Object)recoveryContextWorker));
            }
        }
    }
}

