/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.util.Locale;
import weblogic.transaction.XAException;

class JTAHelper {
    JTAHelper() {
    }

    static void throwXAException(int n, String string) throws javax.transaction.xa.XAException {
        XAException xAException = new XAException(n, JTAHelper.xaErrorCodeToString(n) + ".  " + string, null);
        throw xAException;
    }

    static void throwXAException(int n, String string, Throwable throwable) throws javax.transaction.xa.XAException {
        XAException xAException = new XAException(n, JTAHelper.xaErrorCodeToString(n) + ".  " + string, throwable);
        throw xAException;
    }

    static String xaErrorCodeToString(int n) {
        return JTAHelper.xaErrorCodeToString(n, true);
    }

    static String xaErrorCodeToString(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        switch (n) {
            case 0: {
                return "XA_OK";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 7: {
                stringBuffer.append("XA_HEURCOM");
                if (bl) {
                    stringBuffer.append(" : The transaction branch has been heuristically committed");
                }
                return stringBuffer.toString();
            }
            case 8: {
                stringBuffer.append("XA_HEURHAZ");
                if (bl) {
                    stringBuffer.append(" : The transaction branch may have been heuristically completed");
                }
                return stringBuffer.toString();
            }
            case 5: {
                stringBuffer.append("XA_HEURMIX");
                if (bl) {
                    stringBuffer.append(" : The transaction branch has been heuristically committed and rolled back");
                }
                return stringBuffer.toString();
            }
            case 6: {
                stringBuffer.append("XA_HEURRB");
                if (bl) {
                    stringBuffer.append(" : The transaction branch has been heuristically rolled back");
                }
                return stringBuffer.toString();
            }
            case 101: {
                stringBuffer.append("XA_RBCOMMFAIL");
                if (bl) {
                    stringBuffer.append(" : Rollback was caused by communication failure");
                }
                return stringBuffer.toString();
            }
            case 102: {
                stringBuffer.append("XA_RBDEADLOCK");
                if (bl) {
                    stringBuffer.append(" : A deadlock was detected");
                }
                return stringBuffer.toString();
            }
            case 103: {
                stringBuffer.append("XA_RBINTEGRITY");
                if (bl) {
                    stringBuffer.append(" : A condition that violates the integrity of the resource was detected");
                }
                return stringBuffer.toString();
            }
            case 104: {
                stringBuffer.append("XA_RBOTHER");
                if (bl) {
                    stringBuffer.append(" : The resource manager rolled back the transaction branch for a reason not on this list");
                }
                return stringBuffer.toString();
            }
            case 105: {
                stringBuffer.append("XA_RBPROTO");
                if (bl) {
                    stringBuffer.append(" : A protocol error occured in the resource manager");
                }
                return stringBuffer.toString();
            }
            case 100: {
                stringBuffer.append("XA_RBROLLBACK");
                if (bl) {
                    stringBuffer.append(" : Rollback was caused by unspecified reason");
                }
                return stringBuffer.toString();
            }
            case 106: {
                stringBuffer.append("XA_RBTIMEOUT");
                if (bl) {
                    stringBuffer.append(" : A transaction branch took too long");
                }
                return stringBuffer.toString();
            }
            case 107: {
                stringBuffer.append("XA_RBTRANSIENT");
                if (bl) {
                    stringBuffer.append(" : May retry the transaction branch");
                }
                return stringBuffer.toString();
            }
            case -2: {
                stringBuffer.append("XAER_ASYNC");
                if (bl) {
                    stringBuffer.append(" : Asynchronous operation already outstanding");
                }
                return stringBuffer.toString();
            }
            case -8: {
                stringBuffer.append("XAER_DUPID");
                if (bl) {
                    stringBuffer.append(" : The XID already exists");
                }
                return stringBuffer.toString();
            }
            case -5: {
                stringBuffer.append("XAER_INVAL");
                if (bl) {
                    stringBuffer.append(" : Invalid arguments were given");
                }
                return stringBuffer.toString();
            }
            case -4: {
                stringBuffer.append("XAER_NOTA");
                if (bl) {
                    stringBuffer.append(" : The XID is not valid");
                }
                return stringBuffer.toString();
            }
            case -9: {
                stringBuffer.append("XAER_OUTSIDE");
                if (bl) {
                    stringBuffer.append(" : The resource manager is doing work outside global transaction");
                }
                return stringBuffer.toString();
            }
            case -6: {
                stringBuffer.append("XAER_PROTO");
                if (bl) {
                    stringBuffer.append(" : Routine was invoked in an inproper context");
                }
                return stringBuffer.toString();
            }
            case -3: {
                stringBuffer.append("XAER_RMERR");
                if (bl) {
                    stringBuffer.append(" : A resource manager error has occured in the transaction branch");
                }
                return stringBuffer.toString();
            }
            case -7: {
                stringBuffer.append("XAER_RMFAIL");
                if (bl) {
                    stringBuffer.append(" : Resource manager is unavailable");
                }
                return stringBuffer.toString();
            }
        }
        return Integer.toHexString(n).toUpperCase(Locale.ENGLISH);
    }
}

