/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.transaction.WLXid;
import weblogic.transaction.XIDFactory;
import weblogic.transaction.internal.XidImpl;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.wsat.WSATHelper;

public class TransactionIdHelperImpl
extends TransactionIdHelper {
    private static final int FFID = 65309;
    private final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private Map<String, Xid> tids2xids = new HashMap<String, Xid>();
    private Map<Xid, String> xids2tids = new HashMap<Xid, String>();

    public String xid2wsatid(WLXid wLXid) {
        return wLXid.toString();
    }

    public WLXid wsatid2xid(String string) {
        return XidImpl.create((String)string);
    }

    public synchronized Xid getOrCreateXid(byte[] byArray) {
        Xid xid = this.getXid(byArray);
        if (xid != null) {
            return xid;
        }
        byte[] byArray2 = WSATHelper.assignUUID().getBytes();
        xid = XIDFactory.createXID((int)65309, (byte[])byArray2, null);
        String string = new String(byArray);
        this.tids2xids.put(string, xid);
        this.xids2tids.put(xid, string);
        if (this.debugWSAT.isDebugEnabled()) {
            this.debugWSAT.debug("created mapping foreign Transaction Id " + string + " to local Xid " + xid);
        }
        return xid;
    }

    public synchronized byte[] getTid(Xid xid) {
        String string = this.xids2tids.get(xid);
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    public synchronized Xid getXid(byte[] byArray) {
        return this.tids2xids.get(new String(byArray));
    }

    public synchronized Xid remove(byte[] byArray) {
        if (this.getXid(byArray) == null) {
            return null;
        }
        Xid xid = this.tids2xids.remove(byArray);
        this.xids2tids.remove(xid);
        return xid;
    }

    public synchronized byte[] remove(Xid xid) {
        if (this.getTid(xid) == null) {
            return null;
        }
        String string = this.xids2tids.remove(xid);
        this.tids2xids.remove(string);
        return string.getBytes();
    }

    public String toString() {
        return this.tids2xids.toString();
    }
}

