/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.transaction.InterposedTransactionManager;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.WLXid;
import weblogic.utils.StackTraceUtils;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.TransactionServices;
import weblogic.wsee.wstx.internal.ForeignRecoveryContext;
import weblogic.wsee.wstx.internal.ForeignRecoveryContextManager;
import weblogic.wsee.wstx.internal.JTAHelper;
import weblogic.wsee.wstx.internal.WSATGatewayRM;
import weblogic.wsee.wstx.wsat.WSATException;
import weblogic.wsee.wstx.wsat.WSATHelper;

public class WLSTransactionServicesImpl
implements TransactionServices {
    private final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private static TransactionServices singleton;

    static synchronized TransactionServices create() throws NamingException {
        if (singleton == null) {
            singleton = new WLSTransactionServicesImpl();
        }
        return singleton;
    }

    public static TransactionServices getInstance() {
        return singleton;
    }

    private WLSTransactionServicesImpl() {
        ForeignRecoveryContextManager.getInstance().start();
    }

    public byte[] enlistResource(XAResource xAResource, Xid xid) throws WSATException {
        WSATGatewayRM wSATGatewayRM = WSATGatewayRM.getInstance();
        if (wSATGatewayRM == null) {
            throw new WSATException("WS-AT gateway not deployed.");
        }
        try {
            return wSATGatewayRM.registerWSATResource(xid, xAResource);
        }
        catch (IllegalStateException illegalStateException) {
            throw new WSATException(illegalStateException);
        }
        catch (RollbackException rollbackException) {
            throw new WSATException((Exception)((Object)rollbackException));
        }
        catch (SystemException systemException) {
            throw new WSATException((Exception)((Object)systemException));
        }
    }

    public void registerSynchronization(Synchronization synchronization, Xid xid) throws WSATException {
        Transaction transaction = (Transaction)this.getTM().getTransaction(xid);
        if (transaction == null) {
            this.log("registerSynchronization() no transaction matching " + xid);
            throw new WSATException("WLSTransactionServiceImpl.registerSynchronization() no transaction matching " + xid);
        }
        try {
            transaction.registerSynchronization(synchronization);
        }
        catch (IllegalStateException illegalStateException) {
            this.log("registerSynchronization() xid=" + xid + ", synchronization=" + synchronization + ": " + StackTraceUtils.throwable2StackTrace((Throwable)illegalStateException));
            throw new WSATException(illegalStateException);
        }
        catch (RollbackException rollbackException) {
            this.log("registerSynchronization() xid=" + xid + ", synchronization=" + synchronization + ": " + StackTraceUtils.throwable2StackTrace((Throwable)rollbackException));
            throw new WSATException((Exception)((Object)rollbackException));
        }
        catch (SystemException systemException) {
            this.log("registerSynchronization() xid=" + xid + ", synchronization=" + synchronization + ": " + StackTraceUtils.throwable2StackTrace((Throwable)systemException));
            throw new WSATException((Exception)((Object)systemException));
        }
    }

    public int getExpires() {
        Transaction transaction = this.currentTransaction();
        if (transaction != null) {
            return (int)(transaction.getTimeToLiveMillis() / 1000L);
        }
        return 0;
    }

    public byte[] getGlobalTransactionId() {
        Transaction transaction = this.currentTransaction();
        if (transaction != null) {
            return transaction.getXid().getGlobalTransactionId();
        }
        return null;
    }

    public EndpointReference getParentReference(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("No subordinate transaction " + xid);
        }
        Transaction transaction = (Transaction)this.getTM().getTransaction(xid);
        if (transaction == null) {
            throw new IllegalArgumentException("No subordinate transaction " + xid);
        }
        ForeignRecoveryContext foreignRecoveryContext = (ForeignRecoveryContext)transaction.getProperty("weblogic.wsee.wstx.foreignContext");
        if (foreignRecoveryContext == null) {
            throw new AssertionError((Object)("No recovery context associated with transaction " + xid));
        }
        return foreignRecoveryContext.getEndpointReference();
    }

    public Xid importTransaction(int n, byte[] byArray) throws WSATException {
        Xid xid = TransactionIdHelper.getInstance().getOrCreateXid(byArray);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("importTransaction tId=" + new String(byArray) + " foreignXid=" + xid);
        }
        XAResource xAResource = this.getGatewayXAResource();
        try {
            xAResource.setTransactionTimeout(n);
            xAResource.start(xid, 0);
            Transaction transaction = (Transaction)this.getTM().getTransaction();
            if (transaction == null) {
                this.log("no local transaction context for imported transaction " + new String(byArray) + "(" + xid + ")");
                throw new WSATException("Unable to import foreign WS-AT transaction " + new String(byArray));
            }
            return xid;
        }
        catch (XAException xAException) {
            this.log("importTransaction tid=" + new String(byArray) + ", XAException=" + StackTraceUtils.throwable2StackTrace((Throwable)xAException));
            throw new WSATException(xAException);
        }
        catch (SystemException systemException) {
            this.log("importTransaction tid=" + new String(byArray) + ", SystemException=" + StackTraceUtils.throwable2StackTrace((Throwable)systemException));
            throw new WSATException((Exception)((Object)systemException));
        }
    }

    public String prepare(byte[] byArray) throws WSATException {
        WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(new String(byArray));
        if (wLXid == null) {
            this.log("prepare() tid=" + new String(byArray) + " no mapping to foreign Xid");
            throw new WSATException("Transaction identifier does not exist: " + new String(byArray));
        }
        XAResource xAResource = this.getGatewayXAResource();
        try {
            int n = xAResource.prepare((Xid)wLXid);
            switch (n) {
                case 0: {
                    return "Prepared";
                }
                case 3: {
                    return "ReadOnly";
                }
            }
            this.log("Unknown return value from prepare: " + n);
            throw new WSATException("Unknown return value from prepare: " + n);
        }
        catch (XAException xAException) {
            this.log("prepare() tid=" + new String(byArray) + " (" + wLXid + ") XAException (" + JTAHelper.xaErrorCodeToString(xAException.errorCode, false) + "): " + StackTraceUtils.throwable2StackTrace((Throwable)xAException));
            throw new WSATException("XAException during prepare of " + new String(byArray) + ": " + xAException, xAException);
        }
    }

    public void commit(byte[] byArray) throws WSATException {
        WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(new String(byArray));
        if (wLXid == null) {
            this.log("commit() tid=" + new String(byArray) + " no mapping to foreign Xid");
            throw new WSATException("Transaction identifier does not exist: " + new String(byArray));
        }
        boolean bl = false;
        XAResource xAResource = this.getGatewayXAResource();
        try {
            xAResource.commit((Xid)wLXid, false);
            bl = true;
        }
        catch (XAException xAException) {
            this.log("commit() tid=" + new String(byArray) + " (" + wLXid + "), XAException (" + JTAHelper.xaErrorCodeToString(xAException.errorCode, false) + ") committing imported transaction: " + StackTraceUtils.throwable2StackTrace((Throwable)xAException));
            switch (xAException.errorCode) {
                case 7: {
                    bl = true;
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    bl = true;
                    throw new WSATException("branch completed heuristically for " + new String(byArray) + ": " + xAException, xAException);
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    String string = "commit() tid=" + new String(byArray) + " (" + wLXid + "), invalid errorCode XA_RB..., no one-phase support XAException:" + xAException;
                    this.log(string);
                    bl = true;
                    throw new WSATException(string, xAException);
                }
                case -7: 
                case -6: 
                case -5: 
                case -3: {
                    throw new WSATException("XAException for " + new String(byArray) + ": " + xAException, xAException);
                }
                case -4: {
                    bl = true;
                    break;
                }
                default: {
                    this.log("commit() tid=" + new String(byArray) + " (" + wLXid + "), unexpected XAException error code " + xAException.errorCode + ": " + xAException.getMessage());
                    throw new WSATException("Unexpected XAException: " + xAException, xAException);
                }
            }
            throw new WSATException("XAException during commit of " + String.valueOf(byArray) + ": " + xAException, xAException);
        }
        finally {
            if (bl) {
                this.deleteForeignState((Xid)wLXid);
            }
        }
    }

    public void rollback(byte[] byArray) throws WSATException {
        WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(new String(byArray));
        if (wLXid == null) {
            this.log("rollback() tid=" + new String(byArray) + " no mapping to foreign Xid");
        }
        boolean bl = false;
        XAResource xAResource = this.getGatewayXAResource();
        try {
            xAResource.rollback((Xid)wLXid);
            bl = true;
        }
        catch (XAException xAException) {
            this.log("rollback() tid=" + new String(byArray) + " (" + wLXid + "), XAException (" + JTAHelper.xaErrorCodeToString(xAException.errorCode, false) + ") rolling back imported transaction: " + StackTraceUtils.throwable2StackTrace((Throwable)xAException));
            switch (xAException.errorCode) {
                case 6: {
                    bl = true;
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    bl = true;
                    throw new WSATException("branch completed heuristically for " + new String(byArray) + ": " + xAException, xAException);
                }
                case -7: 
                case -6: 
                case -5: 
                case -3: {
                    throw new WSATException("XAException for " + new String(byArray) + ": " + xAException, xAException);
                }
                case -4: {
                    bl = true;
                    break;
                }
                default: {
                    this.log("rollback() tid=" + new String(byArray) + " (" + wLXid + "), unexpected XAException error code " + xAException.errorCode + ": " + xAException.getMessage());
                    throw new WSATException("Unexpected XAException: " + xAException, xAException);
                }
            }
            throw new WSATException("XAException during rollback of " + new String(byArray) + ": " + xAException, xAException);
        }
        finally {
            if (bl) {
                this.deleteForeignState((Xid)wLXid);
            }
        }
    }

    public void replayCompletion(String string, XAResource xAResource) throws WSATException {
        WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(string);
        Transaction transaction = (Transaction)this.getTM().getTransaction((Xid)wLXid);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("replayCompletion() tid=" + string + " xid=" + wLXid + " transaction=" + transaction);
        }
        if (transaction == null) {
            try {
                xAResource.rollback((Xid)wLXid);
            }
            catch (XAException xAException) {
                this.log("replayCompletion() tid=" + string + " (" + wLXid + "), XAException (" + JTAHelper.xaErrorCodeToString(xAException.errorCode, false) + ") rolling back imported transaction: " + StackTraceUtils.throwable2StackTrace((Throwable)xAException));
                throw new WSATException("XAException on rollback of subordinate in response to replayCompletion for " + wLXid + "(tid=" + string + ")", xAException);
            }
        }
    }

    private void deleteForeignState(Xid xid) {
        TransactionIdHelper.getInstance().remove(xid);
        ForeignRecoveryContextManager.getInstance().remove(xid);
    }

    private TransactionManager getTM() {
        return (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    private Transaction currentTransaction() {
        Transaction transaction = null;
        try {
            transaction = (Transaction)this.getTM().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return transaction;
    }

    private XAResource getGatewayXAResource() {
        InterposedTransactionManager interposedTransactionManager = (InterposedTransactionManager)this.getTM();
        return interposedTransactionManager.getXAResource();
    }

    private void log(String string) {
        WseeWsatLogger.logWLSTransactionServicesImpl((Object)string);
    }

    private void debug(String string) {
        this.debugWSAT.debug("WLSTransactionServicesImpl:" + string);
    }
}

