/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.internal.MigratableRM;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.internal.BranchRecord;
import weblogic.wsee.wstx.internal.JTAHelper;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.WSATXAResource;

public class WSATGatewayRM
implements weblogic.transaction.XAResource,
MigratableRM {
    private static final String RM_NAME_PREFIX = "WSATGatewayRM_";
    private static final String STORE_CONNECTION_NAME = "weblogic.wsee.wstx.gateway";
    private static final int STORE_NO_FLAGS = 0;
    private final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private static WSATGatewayRM singleton;
    private String resourceRegistrationName;
    private Map<Xid, BranchRecord> branches;
    private List<Xid> pendingXids;
    private PersistentStore store;
    private PersistentStoreConnection storeConn;
    private final Object currentBQualLock = new Object();
    private byte[] currentBQual;
    private static TransactionManager m_transactionManager;
    private static Transaction m_transaction;

    private WSATGatewayRM() {
    }

    private WSATGatewayRM(String string, PersistentStore persistentStore) {
        this.resourceRegistrationName = RM_NAME_PREFIX + string;
        this.branches = Collections.synchronizedMap(new HashMap());
        this.pendingXids = Collections.synchronizedList(new ArrayList());
        this.store = persistentStore;
    }

    public static synchronized WSATGatewayRM getInstance() {
        return singleton;
    }

    public static synchronized WSATGatewayRM create(String string, PersistentStore persistentStore) throws SystemException, PersistentStoreException {
        if (singleton == null) {
            singleton = new WSATGatewayRM(string, persistentStore);
            singleton.initStore();
            singleton.recoverPendingBranches();
            singleton.registerResourceWithTM();
        }
        return singleton;
    }

    public synchronized MigratableRM createForMigration(String string, PersistentStore persistentStore) throws SystemException, PersistentStoreException {
        WSATGatewayRM wSATGatewayRM = new WSATGatewayRM(string, persistentStore);
        wSATGatewayRM.initStore();
        wSATGatewayRM.recoverPendingBranches();
        wSATGatewayRM.registerResourceWithTM();
        return wSATGatewayRM;
    }

    private void initStore() throws PersistentStoreException {
        this.storeConn = this.store.createConnection(STORE_CONNECTION_NAME, (ObjectHandler)new BranchObjectHandler());
    }

    private void recoverPendingBranches() throws PersistentStoreException {
        PersistentStoreRecord persistentStoreRecord;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recoverPendingBranches()");
        }
        PersistentStoreConnection.Cursor cursor = this.storeConn.createCursor(0);
        while ((persistentStoreRecord = cursor.next()) != null) {
            BranchRecord branchRecord = (BranchRecord)persistentStoreRecord.getData();
            branchRecord.setStoreHandle(persistentStoreRecord.getHandle());
            this.branches.put(branchRecord.getXid(), branchRecord);
            this.pendingXids.addAll(branchRecord.getAllXids());
            if (!WSATHelper.isDebugEnabled()) continue;
            this.debug("recovered: " + branchRecord);
        }
    }

    private void registerResourceWithTM() throws SystemException {
        this.getTM().registerDynamicResource(this.resourceRegistrationName, (XAResource)((Object)this));
    }

    public void stop() {
        try {
            this.unregisterResource();
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
        }
    }

    private void unregisterResource() throws SystemException {
        TransactionManager transactionManager = this.getTM();
        transactionManager.unregisterResource(this.resourceRegistrationName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] registerWSATResource(Xid xid, XAResource xAResource) throws IllegalStateException, RollbackException, SystemException {
        byte[] byArray;
        Transaction transaction = this.getTransaction(xid);
        if (transaction == null) {
            throw new IllegalStateException("Transaction " + xid + " does not exist, wsatResource=" + xAResource);
        }
        transaction.enlistResource((XAResource)((Object)this));
        BranchRecord branchRecord = this.getOrCreateBranch(xid);
        XAResource xAResource2 = branchRecord.exists(xAResource);
        if (xAResource2 != null) {
            return ((WSATXAResource)xAResource2).getXid().getBranchQualifier();
        }
        branchRecord.addSubordinate(xAResource);
        Object object = this.currentBQualLock;
        synchronized (object) {
            String string = branchRecord.getBranchName(xAResource) + WSATHelper.assignUUID();
            transaction.enlistResource((XAResource)((Object)this), string);
            byArray = this.currentBQual;
            this.currentBQual = null;
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("registerWSATResource() xid=" + xid + " currentBQual=" + String.valueOf(this.currentBQual) + " bqual=" + String.valueOf(byArray));
        }
        return byArray;
    }

    public void start(Xid xid, int n) throws XAException {
        this.currentBQual = xid.getBranchQualifier();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("start() xid=" + xid + ", flags=" + n + ", currentBQual=" + String.valueOf(this.currentBQual));
        }
        switch (n) {
            case 0: {
                this.getOrCreateBranch(xid);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                BranchRecord branchRecord = this.getBranch(xid);
                if (branchRecord != null) break;
                JTAHelper.throwXAException(-4, "Attempt to resume xid " + xid + " that is not in SUSPENDED state.");
                break;
            }
            case 0x20000000: {
                JTAHelper.throwXAException(-3, "error while attempting to rollback branch" + this.resourceRegistrationName);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid flag:" + n);
            }
        }
    }

    public void end(Xid xid, int n) throws XAException {
        BranchRecord branchRecord;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("end() xid=" + xid + ", flags=" + n);
        }
        if ((branchRecord = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "end: no branch info for " + xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        BranchRecord branchRecord;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid);
        }
        if ((branchRecord = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "prepare: no branch info for " + xid);
        }
        this.persistBranchIfNecessary(branchRecord);
        return branchRecord.prepare(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        BranchRecord branchRecord;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit() xid=" + xid);
        }
        if ((branchRecord = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "commit: no branch information for xid:" + xid);
        }
        try {
            branchRecord.commit(xid, bl);
        }
        finally {
            this.deleteBranchIfNecessary(branchRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        BranchRecord branchRecord;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("rollback() xid=" + xid);
        }
        if ((branchRecord = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "rollback: no branch info for " + xid);
        }
        try {
            branchRecord.rollback(xid);
        }
        finally {
            this.deleteBranchIfNecessary(branchRecord, true);
        }
    }

    public Xid[] recover(int n) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recover() flag=" + n);
        }
        if ((n & 0x1000000) != 0) {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("WSAT recover(" + n + ") returning " + this.pendingXids);
            }
            Xid[] xidArray = this.pendingXids.toArray(new Xid[this.pendingXids.size()]);
            return xidArray;
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recover() returning nothing");
        }
        return new Xid[0];
    }

    public void forget(Xid xid) throws XAException {
        BranchRecord branchRecord;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("forget() xid=" + xid);
        }
        if ((branchRecord = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "forget: no branch info for " + xid);
        }
        this.deleteBranchIfNecessary(branchRecord);
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof WSATGatewayRM)) {
            return false;
        }
        WSATGatewayRM wSATGatewayRM = (WSATGatewayRM)((Object)xAResource);
        return this.equals(wSATGatewayRM);
    }

    public boolean detectedUnavailable() {
        return true;
    }

    public int getDelistFlag() {
        return 0x4000000;
    }

    private synchronized BranchRecord getOrCreateBranch(Xid xid) {
        BranchRecord branchRecord = this.getBranch(xid);
        if (branchRecord == null) {
            branchRecord = new BranchRecord(xid);
            this.branches.put(xid, branchRecord);
        }
        return branchRecord;
    }

    private synchronized BranchRecord getBranch(Xid xid) {
        BranchRecord branchRecord = this.branches.get(xid);
        if (branchRecord != null && xid.getBranchQualifier() != null) {
            branchRecord.assignBranchXid(xid);
        }
        return branchRecord;
    }

    private void delete(BranchRecord branchRecord, boolean bl) throws PersistentStoreException {
        if (bl) {
            this.releaseBranchRecord(branchRecord);
        }
        this.branches.remove(branchRecord.getXid());
        this.pendingXids.removeAll(branchRecord.getAllXids());
    }

    private void persistBranchRecord(BranchRecord branchRecord) throws PersistentStoreException {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("persist branch record " + branchRecord);
        }
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        PersistentHandle persistentHandle = this.storeConn.create(persistentStoreTransaction, (Object)branchRecord, 0);
        persistentStoreTransaction.commit();
        branchRecord.setStoreHandle(persistentHandle);
        branchRecord.setLogged(true);
    }

    private void releaseBranchRecord(BranchRecord branchRecord) throws PersistentStoreException {
        PersistentHandle persistentHandle;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("release branch record " + branchRecord);
        }
        if ((persistentHandle = branchRecord.getStoreHandle()) == null) {
            return;
        }
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        this.storeConn.delete(persistentStoreTransaction, persistentHandle, 0);
        persistentStoreTransaction.commit();
        branchRecord.setStoreHandle(null);
        branchRecord.setLogged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistBranchIfNecessary(BranchRecord branchRecord) throws XAException {
        try {
            BranchRecord branchRecord2 = branchRecord;
            synchronized (branchRecord2) {
                if (!branchRecord.isLogged()) {
                    this.persistBranchRecord(branchRecord);
                    this.pendingXids.addAll(branchRecord.getAllXids());
                }
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            this.debug("error persisting branch " + branchRecord + ": " + persistentStoreException.toString());
            WseeWsatLogger.logErrorPersistingBranchRecord((String)branchRecord.toString(), (Throwable)persistentStoreException);
            JTAHelper.throwXAException(-3, "Error persisting branch " + branchRecord, persistentStoreException);
        }
    }

    private boolean deleteBranchIfNecessary(BranchRecord branchRecord) throws XAException {
        return this.deleteBranchIfNecessary(branchRecord, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteBranchIfNecessary(BranchRecord branchRecord, boolean bl) throws XAException {
        boolean bl2 = false;
        try {
            BranchRecord branchRecord2 = branchRecord;
            synchronized (branchRecord2) {
                boolean bl3 = branchRecord.isLogged();
                if ((bl3 || bl) && branchRecord.allResourcesCompleted()) {
                    this.delete(branchRecord, bl3);
                    bl2 = true;
                }
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            this.debug("error deleting branch record " + branchRecord + ": " + persistentStoreException.toString());
            WseeWsatLogger.logErrorDeletingBranchRecord((String)branchRecord.toString(), (Throwable)persistentStoreException);
            JTAHelper.throwXAException(-3, "Error deleting branch record " + branchRecord, persistentStoreException);
        }
        return bl2;
    }

    private TransactionManager getTM() {
        return m_transactionManager != null ? m_transactionManager : (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    private Transaction getTransaction(Xid xid) {
        if (m_transaction != null) {
            return m_transaction;
        }
        TransactionManager transactionManager = this.getTM();
        return (Transaction)transactionManager.getTransaction(xid);
    }

    static void setTM(TransactionManager transactionManager) {
        m_transactionManager = transactionManager;
    }

    static void setTx(Transaction transaction) {
        m_transaction = transaction;
    }

    private void debug(String string) {
        if (WSATHelper.isDebugEnabled()) {
            this.debugWSAT.debug("[WSATGatewayRM] " + this.resourceRegistrationName + " msg:" + string);
        }
    }

    static {
        ServerTransactionManagerImpl.registerMigratableRM((MigratableRM)new WSATGatewayRM());
    }

    private final class BranchObjectHandler
    implements ObjectHandler {
        private static final int VERSION = 1;

        private BranchObjectHandler() {
        }

        public Object readObject(ObjectInput objectInput) throws ClassNotFoundException, IOException {
            int n = objectInput.readInt();
            if (n != 1) {
                throw new IOException("Stream corrupted.  Invalid WS-AT gateway branch version: " + n);
            }
            BranchRecord branchRecord = new BranchRecord();
            branchRecord.readExternal(objectInput);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.this.debug("read WS-AT branch " + branchRecord);
            }
            return branchRecord;
        }

        public void writeObject(ObjectOutput objectOutput, Object object) throws IOException {
            if (!(object instanceof BranchRecord)) {
                throw new IOException("Cannot serialize class of type: " + (object == null ? null : object.getClass().toString()));
            }
            objectOutput.writeInt(1);
            BranchRecord branchRecord = (BranchRecord)object;
            branchRecord.writeExternal(objectOutput);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.this.debug("serialized WS-AT branch " + branchRecord);
            }
        }
    }
}

