/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.internal;

import java.security.AccessController;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.wsee.wstx.TransactionServices;
import weblogic.wsee.wstx.internal.WLSTransactionServicesImpl;
import weblogic.wsee.wstx.internal.WSATGatewayRM;

public class WSATTransactionService
extends AbstractServerService {
    private TransactionServices transactionServices;
    private WSATGatewayRM wsatgw;
    private final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        if (this.debugWSAT.isDebugEnabled()) {
            this.debugWSAT.debug("starting WSAT Transaction Service");
        }
        try {
            this.transactionServices = WLSTransactionServicesImpl.create();
            PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
            PersistentStore persistentStore = persistentStoreManager.getDefaultStore();
            String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
            String string2 = ManagementService.getRuntimeAccess(kernelId).getDomainName();
            this.wsatgw = WSATGatewayRM.create(string + "_" + string2, persistentStore);
        }
        catch (NamingException namingException) {
            if (this.debugWSAT.isDebugEnabled()) {
                this.debugWSAT.debug(namingException.getMessage(), (Throwable)namingException);
            }
            throw new ServiceFailureException((Throwable)namingException);
        }
        catch (SystemException systemException) {
            if (this.debugWSAT.isDebugEnabled()) {
                this.debugWSAT.debug(systemException.getMessage(), (Throwable)systemException);
            }
            throw new ServiceFailureException((Throwable)systemException);
        }
        catch (PersistentStoreException persistentStoreException) {
            if (this.debugWSAT.isDebugEnabled()) {
                this.debugWSAT.debug(persistentStoreException.getMessage(), (Throwable)persistentStoreException);
            }
            throw new ServiceFailureException((Throwable)persistentStoreException);
        }
    }

    public void stop() throws ServiceFailureException {
        if (this.debugWSAT.isDebugEnabled()) {
            this.debugWSAT.debug("stopping WSAT Transaction Service");
        }
        this.wsatgw.stop();
    }
}

