/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.WLXid;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.security.IssuedTokenBuilder;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATClientHandler
implements SOAPHandler<SOAPMessageContext> {
    private weblogic.transaction.Transaction m_suspendedTransaction = null;
    Name m_mustUnderstandName;

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logEnterClientSideHandleMessage((Object)sOAPMessageContext);
        }
        boolean bl = (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        SOAPHeader sOAPHeader = null;
        try {
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            sOAPHeader = sOAPMessage.getSOAPHeader();
            this.createMustUnderstandName(sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
            return false;
        }
        boolean bl2 = this.doHandleMessage((SOAPHeader)(bl ? sOAPHeader : null), bl);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logExitClientSideHandleMessage((boolean)bl2, (Object)sOAPMessageContext);
        }
        return bl2;
    }

    public void createMustUnderstandName(SOAPMessage sOAPMessage) throws SOAPException {
        this.m_mustUnderstandName = sOAPMessage.getSOAPPart().getEnvelope().createName("mustUnderstand", "wsa", "http://schemas.xmlsoap.org/soap/envelope");
    }

    public boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logEnterClientSideHandleFault((Object)sOAPMessageContext);
        }
        boolean bl = (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        boolean bl2 = true;
        if (!bl && this.m_suspendedTransaction != null) {
            bl2 = this.resume();
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logExitClientSideHandleFault((boolean)bl2, (Object)sOAPMessageContext);
        }
        return bl2;
    }

    public void close(MessageContext messageContext) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logEnterClientSideClose((Object)messageContext);
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logExitClientSideClose((Object)messageContext);
        }
    }

    public boolean doHandleMessage(SOAPHeader sOAPHeader, boolean bl) {
        boolean bl2;
        weblogic.transaction.Transaction transaction = this.getTransaction();
        boolean bl3 = bl2 = transaction != null;
        if (bl) {
            if (!bl2) {
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logOutboundApplicationMessageNoTransaction();
                }
                return true;
            }
            transaction.setLocalProperty("weblogic.transaction.otsTransactionExport", null);
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logOutboundApplicationMessageTransactionBeforeAddingContext((Object)transaction);
            }
            this.processTransactionalRequest(sOAPHeader, transaction);
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logOutboundApplicationMessageTransactionAfterAddingContext((Object)transaction);
            }
        } else {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logInboundApplicationMessage();
            }
            if (this.m_suspendedTransaction != null && !this.resume()) {
                return false;
            }
        }
        return true;
    }

    public weblogic.transaction.Transaction getTransaction() {
        return (weblogic.transaction.Transaction)this.getTransactionHelper().getTransaction();
    }

    TransactionHelper getTransactionHelper() {
        return TransactionHelper.getTransactionHelper();
    }

    private boolean resume() {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWillResumeInClientSideHandler((Object)this.m_suspendedTransaction, (Object)Thread.currentThread());
        }
        try {
            this.getTransactionHelper().getTransactionManager().resume((Transaction)this.m_suspendedTransaction);
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logResumedInClientSideHandler((Object)this.m_suspendedTransaction, (Object)Thread.currentThread());
            }
            return true;
        }
        catch (InvalidTransactionException invalidTransactionException) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logInvalidTransactionExceptionInClientSideHandler((Exception)((Object)invalidTransactionException), (Object)this.m_suspendedTransaction, (Object)Thread.currentThread());
            }
            this.getTransactionHelper().getTransactionManager().forceResume((Transaction)this.m_suspendedTransaction);
            this.m_suspendedTransaction.setRollbackOnly((Throwable)invalidTransactionException);
            return false;
        }
        catch (SystemException systemException) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logSystemExceptionInClientSideHandler((Exception)((Object)systemException), (Object)this.m_suspendedTransaction, (Object)Thread.currentThread());
            }
            this.getTransactionHelper().getTransactionManager().forceResume((Transaction)this.m_suspendedTransaction);
            this.m_suspendedTransaction.setRollbackOnly((Throwable)systemException);
            return false;
        }
    }

    private boolean processTransactionalRequest(SOAPHeader sOAPHeader, weblogic.transaction.Transaction transaction) {
        if (!this.suspend()) {
            return false;
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logSuspendSuccessfulInClientSideHandler((Object)transaction, (Object)Thread.currentThread());
        }
        String string = this.getWSATTxIdForTransaction(transaction);
        long l = transaction.getTimeToLiveMillis();
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWSATInfoInClientSideHandler((String)string, (long)l, (Object)transaction, (Object)Thread.currentThread());
        }
        try {
            this.addCoordinationContext(sOAPHeader, string, l);
        }
        catch (SOAPException sOAPException) {
            WseeWsatLogger.logSOAPExceptionCreatingCoordinatorContext((Exception)((Object)sOAPException), (Object)transaction, (Object)Thread.currentThread());
            return false;
        }
        return true;
    }

    void addCoordinationContext(SOAPHeader sOAPHeader, String string, long l) throws SOAPException {
        SOAPElement sOAPElement = sOAPHeader.addChildElement("CoordinationContext", "wscoor", "http://schemas.xmlsoap.org/ws/2004/10/wscoor");
        sOAPElement.addAttribute(this.m_mustUnderstandName, "1");
        SOAPElement sOAPElement2 = sOAPElement.addChildElement("Identifier", "wscoor", "http://schemas.xmlsoap.org/ws/2004/10/wscoor");
        sOAPElement2.setValue("urn:uuid:" + string);
        sOAPElement.addChildElement("Expires", "wscoor", "http://schemas.xmlsoap.org/ws/2004/10/wscoor").setValue("" + l);
        sOAPElement.addChildElement("CoordinationType", "wscoor", "http://schemas.xmlsoap.org/ws/2004/10/wscoor").setValue("http://schemas.xmlsoap.org/ws/2004/10/wsat");
        SOAPElement sOAPElement3 = sOAPElement.addChildElement("RegistrationService", "wscoor", "http://schemas.xmlsoap.org/ws/2004/10/wscoor");
        sOAPElement3.addChildElement("Address", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing").setValue(this.getRegistrationCoordinatorAddress());
        SOAPElement sOAPElement4 = sOAPElement3.addChildElement("ReferenceParameters", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        sOAPElement4.addChildElement("txId", "wls-wsat", "http://weblogic.wsee.wstx.wsat/ws/2008/10/wsat").setValue(string);
        if (WSATTubeHelper.isIssuedTokenEnabled()) {
            Element element = IssuedTokenBuilder.v12().buildFromAppliesToElement((Element)sOAPElement2);
            sOAPHeader.appendChild(sOAPHeader.getOwnerDocument().importNode(element, true));
        }
    }

    String getRegistrationCoordinatorAddress() {
        return WSATHelper.getInstance().getRegistrationCoordinatorAddress();
    }

    String getWSATTxIdForTransaction(weblogic.transaction.Transaction transaction) {
        return TransactionIdHelper.getInstance().xid2wsatid((WLXid)transaction.getXID());
    }

    private boolean suspend() {
        try {
            ClientTransactionManager clientTransactionManager = this.getTransactionHelper().getTransactionManager();
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logAboutToSuspendInClientSideHandler((Object)clientTransactionManager, (Object)Thread.currentThread());
            }
            this.m_suspendedTransaction = (weblogic.transaction.Transaction)clientTransactionManager.suspend();
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logSuspendedInClientSideHandler((Object)this.m_suspendedTransaction, (Object)Thread.currentThread());
            }
        }
        catch (SystemException systemException) {
            WseeWsatLogger.logSystemExceptionDuringSuspend((Exception)((Object)systemException), (Object)this.m_suspendedTransaction, (Object)Thread.currentThread());
            return false;
        }
        return true;
    }
}

