/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat;

import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

public class WSATFaultFactory {
    static final String INVALID_STATE = "InvalidState";
    static final String INVALID_PROTOCOL = "InvalidProtocol";
    static final String INVALID_PARAMETERS = "InvalidParameters";
    static final String NO_ACTIVITY = "NoActivity";
    static final String CONTEXT_REFUSED = "ContextRefused";
    static final String ALREADY_REGISTERED = "AlreadyRegistered";
    static final String INCONSISTENT_INTERNAL_STATE = "InconsistentInternalState";
    static final String HTTP_SCHEMAS_XMLSOAP_ORG_WS_2004_10_WSAT_FAULT = "http://schemas.xmlsoap.org/ws/2004/10/wsat/fault";
    private static final String CLIENT = "Client";
    static final QName FAULT_CODE_Q_NAME11 = new QName("http://www.w3.org/2003/05/soap-envelope", "Client");
    private static final String SENDER = "Sender";
    static final QName FAULT_CODE_Q_NAME = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender");
    private static boolean m_isSOAP11 = true;

    public static void throwInvalidStateFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The message was invalid for the current state of the activity.", INVALID_STATE);
    }

    public static void throwInvalidProtocolFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The protocol is invalid or is not supported by the coordinator.", INVALID_PROTOCOL);
    }

    public static void throwInvalidParametersFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The message contained invalid parameters and could not be processed.", INVALID_PARAMETERS);
    }

    public static void throwNoActivityFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The participant is not responding and is presumed to have ended.", NO_ACTIVITY);
    }

    public static void throwContextRefusedFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The coordination context that was provided could not be accepted.", CONTEXT_REFUSED);
    }

    public static void throwAlreadyRegisteredFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The participant has already registered for the same protocol.", ALREADY_REGISTERED);
    }

    public static void throwInconsistentInternalStateFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("A global consistency failure has occurred. This is an unrecoverable condition.", INCONSISTENT_INTERNAL_STATE);
    }

    static void setSOAPVersion11(boolean bl) {
        m_isSOAP11 = bl;
    }

    private static void throwSpecifiedWSATFault(String string, String string2) {
        try {
            SOAPFault sOAPFault;
            if (m_isSOAP11) {
                sOAPFault = SOAPFactory.newInstance().createFault(string, new QName(HTTP_SCHEMAS_XMLSOAP_ORG_WS_2004_10_WSAT_FAULT, string2, "wsat"));
            } else {
                sOAPFault = SOAPFactory.newInstance((String)"SOAP 1.2 Protocol").createFault();
                sOAPFault.setFaultCode(FAULT_CODE_Q_NAME);
                sOAPFault.appendFaultSubcode(new QName(HTTP_SCHEMAS_XMLSOAP_ORG_WS_2004_10_WSAT_FAULT, string2, "wsat"));
                sOAPFault.addFaultReasonText(string, Locale.ENGLISH);
            }
            throw new SOAPFaultException(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException((Throwable)sOAPException);
        }
    }
}

