/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import javax.xml.soap.SOAPException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.WLXid;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.TransactionServices;
import weblogic.wsee.wstx.internal.BranchXidImpl;
import weblogic.wsee.wstx.internal.WLSTransactionServicesImpl;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.WSATConstants;
import weblogic.wsee.wstx.wsat.WSATSynchronization;
import weblogic.wsee.wstx.wsat.WSATXAResource;
import weblogic.wsee.wstx.wsat.common.CoordinatorIF;
import weblogic.wsee.wstx.wsat.common.ParticipantIF;
import weblogic.wsee.wstx.wsat.common.WSATVersion;
import weblogic.wsee.wstx.wsat.common.client.CoordinatorProxyBuilder;
import weblogic.wsee.wstx.wsat.common.client.ParticipantProxyBuilder;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATHelper<T> {
    public static final WSATHelper V10 = new WSATHelper().WSATVersion(WSATVersion.v10);
    public static final WSATHelper V11 = new WSATHelper(){

        public String getRegistrationCoordinatorAddress() {
            return this.getHostAndPort() + "/wls-wsat/RegistrationPortTypeRPC11";
        }

        public String getCoordinatorAddress() {
            return this.getHostAndPort() + "/wls-wsat/CoordinatorPortType11";
        }

        public String getParticipantAddress() {
            return this.getHostAndPort() + "/wls-wsat/ParticipantPortType11";
        }

        public String getRegistrationRequesterAddress() {
            return this.getHostAndPort() + "/wls-wsat/RegistrationRequesterPortType11";
        }
    }.WSATVersion(WSATVersion.v11);
    private Map<WSATXAResource, ParticipantIF<T>> m_durableParticipantPortMap = new HashMap<WSATXAResource, ParticipantIF<T>>();
    private final Object m_durableParticipantPortMapLock = new Object();
    private Map<Xid, WSATXAResource> m_durableParticipantXAResourceMap = new HashMap<Xid, WSATXAResource>();
    private final Object m_durableParticipantXAResourceMapLock = new Object();
    private Map<Xid, ParticipantIF<T>> m_volatileParticipantPortMap = new HashMap<Xid, ParticipantIF<T>>();
    private final Object m_volatileParticipantPortMapLock = new Object();
    private Map<Xid, WSATSynchronization> m_volatileParticipantSynchronizationMap = new HashMap<Xid, WSATSynchronization>();
    private final Object m_volatileParticipantSynchronizationMapLock = new Object();
    private final int m_waitForReplyTimeout = new Integer(System.getProperty("weblogic.wsee.wstx.wsat.reply.timeout", "120"));
    private final boolean m_isUseLocalServerAddress = Boolean.valueOf(System.getProperty("weblogic.wsee.wstx.wsat.use.local.server.address", "false"));
    private static final AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final RuntimeAccess _runtimeAccess = ManagementService.getRuntimeAccess(_kernelId);
    protected WSATVersion<T> builderFactory;
    private static final DebugLogger debugWSAT = DebugLogger.getDebugLogger((String)"DebugWSAT");

    WSATHelper WSATVersion(WSATVersion wSATVersion) {
        this.builderFactory = wSATVersion;
        return this;
    }

    protected WSATHelper() {
    }

    public static WSATHelper getInstance() {
        return V10;
    }

    public static WSATHelper getInstance(Transactional.Version version2) {
        if (version2 == Transactional.Version.WSAT10 || version2 == Transactional.Version.DEFAULT) {
            return V10;
        }
        if (version2 == Transactional.Version.WSAT12 || version2 == Transactional.Version.WSAT11) {
            return V11;
        }
        throw new WebServiceException("not supported WSAT version");
    }

    public static TransactionServices getTransactionServices() {
        return WLSTransactionServicesImpl.getInstance();
    }

    public int getWaitForReplyTimeout() {
        return this.m_waitForReplyTimeout * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDurableParticipantStatus(Xid xid, String string) {
        WSATXAResource wSATXAResource;
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            wSATXAResource = this.getDurableParticipantXAResourceMap().get(new BranchXidImpl(xid));
        }
        if (wSATXAResource == null) {
            WseeWsatLogger.logXidNotInDurableResourceMap((Object)xid, (String)string);
            return false;
        }
        object = wSATXAResource;
        synchronized (object) {
            wSATXAResource.setStatus(string);
            wSATXAResource.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setVolatileParticipantStatus(Xid xid, String string) {
        WSATSynchronization wSATSynchronization;
        Object object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            wSATSynchronization = this.m_volatileParticipantSynchronizationMap.get(xid);
        }
        if (wSATSynchronization == null) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logXidNotInVolatileResourceMap((Object)xid, (String)string);
            }
            return false;
        }
        object = wSATSynchronization;
        synchronized (object) {
            wSATSynchronization.setStatus(string);
            wSATSynchronization.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDurableParticipant(WSATXAResource wSATXAResource) {
        Object object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            if (this.getDurableParticipantPortMap().containsKey(wSATXAResource)) {
                this.m_durableParticipantPortMap.remove(wSATXAResource);
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logDurablePortRemoved((Object)wSATXAResource);
                }
            }
        }
        object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            if (this.getDurableParticipantXAResourceMap().containsKey(wSATXAResource.getXid())) {
                this.getDurableParticipantXAResourceMap().remove(wSATXAResource.getXid());
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logDurableXAResourceRemoved((Object)wSATXAResource);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeVolatileParticipant(Xid xid) {
        Object object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            if (this.m_volatileParticipantPortMap.containsKey(new BranchXidImpl(xid))) {
                this.m_volatileParticipantPortMap.remove(new BranchXidImpl(xid));
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logVolatilePortRemoved((Object)new BranchXidImpl(xid));
                }
            }
        }
        object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            if (this.m_volatileParticipantSynchronizationMap.containsKey(new BranchXidImpl(xid))) {
                this.m_volatileParticipantSynchronizationMap.remove(new BranchXidImpl(xid));
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logVolatileSynchronizationRemoved((Object)xid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(EndpointReference endpointReference, Xid xid, WSATXAResource wSATXAResource) throws XAException {
        BranchXidImpl branchXidImpl;
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logAboutToSendPrepare((Object)xid, (Object)Thread.currentThread());
        }
        ParticipantIF<BranchXidImpl> participantIF = this.m_durableParticipantXAResourceMapLock;
        synchronized (participantIF) {
            branchXidImpl = new BranchXidImpl(xid);
            this.getDurableParticipantXAResourceMap().put(branchXidImpl, wSATXAResource);
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logDurableParticipantXAResourcePlacedInCacheFromPrepare((Object)xid);
        }
        participantIF = this.getDurableParticipantPort(endpointReference, xid, wSATXAResource);
        branchXidImpl = this.builderFactory.newNotificationBuilder().build();
        participantIF.prepare(branchXidImpl);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logPrepareSent((Object)xid, (Object)Thread.currentThread());
        }
    }

    public void commit(EndpointReference endpointReference, Xid xid, WSATXAResource wSATXAResource) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logAboutToSendCommit((Object)xid, (Object)Thread.currentThread());
        }
        T t = this.builderFactory.newNotificationBuilder().build();
        this.getDurableParticipantPort(endpointReference, xid, wSATXAResource).commit(t);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logCommitSent((Object)xid, (Object)Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(EndpointReference endpointReference, Xid xid, WSATXAResource wSATXAResource) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logAboutToSendRollback((Object)xid, (Object)Thread.currentThread());
        }
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            BranchXidImpl branchXidImpl = new BranchXidImpl(xid);
            this.getDurableParticipantXAResourceMap().put(branchXidImpl, wSATXAResource);
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logRollbackParticipantXAResourcePlacedInCache((Object)xid);
        }
        object = this.builderFactory.newNotificationBuilder().build();
        this.getDurableParticipantPort(endpointReference, xid, wSATXAResource).rollback(object);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logRollbackSent((Object)xid, (Object)Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion(EndpointReference endpointReference, Xid xid, WSATSynchronization wSATSynchronization) throws SOAPException {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logAboutToSendPrepareVolatile((Object)xid, (Object)Thread.currentThread());
        }
        T t = this.builderFactory.newNotificationBuilder().build();
        this.getVolatileParticipantPort(endpointReference, xid).prepare(t);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logPrepareVolatileSent((Object)xid, (Object)Thread.currentThread());
        }
        Object object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            this.m_volatileParticipantSynchronizationMap.put(new BranchXidImpl(xid), wSATSynchronization);
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logPrepareParticipantSynchronizationPlacedInCache((Object)xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParticipantIF<T> getVolatileParticipantPort(EndpointReference endpointReference, Xid xid) throws SOAPException {
        ParticipantIF<T> participantIF;
        Object object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            participantIF = this.m_volatileParticipantPortMap.get(new BranchXidImpl(xid));
        }
        if (participantIF != null) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logVolatileParticipantRetrievedFromCache((Object)xid);
            }
            return participantIF;
        }
        participantIF = this.getParticipantPort(endpointReference, xid, null);
        object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            this.m_volatileParticipantPortMap.put(new BranchXidImpl(xid), participantIF);
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logVolatileParticipantPortPlacedInCache((Object)xid);
        }
        return participantIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParticipantIF<T> getDurableParticipantPort(EndpointReference endpointReference, Xid xid, WSATXAResource wSATXAResource) throws XAException {
        ParticipantIF<T> participantIF;
        Object object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            participantIF = this.getDurableParticipantPortMap().get(wSATXAResource);
        }
        if (participantIF != null) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logDurableParticipantPortRetreivedFromCache((Object)xid);
            }
            return participantIF;
        }
        try {
            participantIF = this.getParticipantPort(endpointReference, xid, new String(wSATXAResource.getXid().getBranchQualifier()));
        }
        catch (SOAPException sOAPException) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logCannotCreateDurableParticipantPort((Object)xid);
            }
            sOAPException.printStackTrace();
            XAException xAException = new XAException("Unable to create durable participant port:" + (Object)((Object)sOAPException));
            xAException.initCause(sOAPException);
            xAException.errorCode = -7;
            throw xAException;
        }
        object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            BranchXidImpl branchXidImpl = new BranchXidImpl(xid);
            this.getDurableParticipantXAResourceMap().put(branchXidImpl, wSATXAResource);
        }
        object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            this.getDurableParticipantPortMap().put(wSATXAResource, participantIF);
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logDurableParticipantPortPlacedInCache((Object)xid);
        }
        return participantIF;
    }

    public ParticipantIF<T> getParticipantPort(EndpointReference endpointReference, Xid xid, String string) throws SOAPException {
        String string2 = TransactionIdHelper.getInstance().xid2wsatid((WLXid)xid);
        ParticipantProxyBuilder<T> participantProxyBuilder = this.builderFactory.newParticipantProxyBuilder();
        ParticipantIF participantIF = ((ParticipantProxyBuilder)((ParticipantProxyBuilder)participantProxyBuilder.to(endpointReference)).txIdForReference(string2, string)).build();
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logSuccessfullyCreatedParticipantPort(participantIF, (Object)xid);
        }
        return participantIF;
    }

    public CoordinatorIF<T> getCoordinatorPort(EndpointReference endpointReference, Xid xid) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getCoordinatorPort xid:" + xid + " epr:" + endpointReference);
        }
        String string = TransactionIdHelper.getInstance().xid2wsatid((WLXid)xid);
        CoordinatorProxyBuilder<T> coordinatorProxyBuilder = this.builderFactory.newCoordinatorProxyBuilder();
        CoordinatorIF coordinatorIF = ((CoordinatorProxyBuilder)((CoordinatorProxyBuilder)coordinatorProxyBuilder.to(endpointReference)).txIdForReference(string, "")).build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getCoordinatorPort xid:" + xid + " epr:" + endpointReference + " coordinatorProxy:" + coordinatorIF);
        }
        return coordinatorIF;
    }

    public String getRoutingAddress() {
        return _runtimeAccess == null ? null : _runtimeAccess.getServerName();
    }

    String getHostAndPort() {
        boolean bl = WSATTubeHelper.isSSLRequired();
        return this.m_isUseLocalServerAddress ? ServerUtil.getLocalServerPublicURL(bl ? "https" : "http") : ServerUtil.getHTTPServerURL(bl);
    }

    public String getRegistrationCoordinatorAddress() {
        return this.getHostAndPort() + "/wls-wsat/RegistrationPortTypeRPC";
    }

    public String getCoordinatorAddress() {
        return this.getHostAndPort() + "/wls-wsat/CoordinatorPortType";
    }

    public String getParticipantAddress() {
        return this.getHostAndPort() + "/wls-wsat/ParticipantPortType";
    }

    public String getRegistrationRequesterAddress() {
        return this.getHostAndPort() + "/wls-wsat/RegistrationRequesterPortType";
    }

    public WLXid getXidFromWebServiceContextHeaderList(WebServiceContext webServiceContext) {
        String string = this.getWSATTidFromWebServiceContextHeaderList(webServiceContext);
        return TransactionIdHelper.getInstance().wsatid2xid(string);
    }

    public String getWSATTidFromWebServiceContextHeaderList(WebServiceContext webServiceContext) {
        MessageContext messageContext = webServiceContext.getMessageContext();
        HeaderList headerList = (HeaderList)messageContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Iterator iterator = headerList.getHeaders(WSATConstants.TXID_QNAME, false);
        if (!iterator.hasNext()) {
            WseeWsatLogger.logWSATNoContextHeaderList((Object)webServiceContext);
            throw new WebServiceException("txid does not exist in header");
        }
        String string = ((Header)iterator.next()).getStringContent();
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWLSWSATTxIdInHeader((String)string, (Object)Thread.currentThread());
        }
        return string;
    }

    public String getBQualFromWebServiceContextHeaderList(WebServiceContext webServiceContext) {
        MessageContext messageContext = webServiceContext.getMessageContext();
        HeaderList headerList = (HeaderList)messageContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Iterator iterator = headerList.getHeaders(WSATConstants.BRANCHQUAL_QNAME, false);
        if (!iterator.hasNext()) {
            throw new WebServiceException("branchqual does not exist in header");
        }
        String string = ((Header)iterator.next()).getStringContent();
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWLSWSATTxIdInHeader((String)string, (Object)Thread.currentThread());
        }
        return string;
    }

    public static boolean isDebugEnabled() {
        return DebugLogger.getDebugLogger((String)"DebugWSAT").isDebugEnabled();
    }

    public Map<WSATXAResource, ParticipantIF<T>> getDurableParticipantPortMap() {
        return this.m_durableParticipantPortMap;
    }

    Map<Xid, WSATXAResource> getDurableParticipantXAResourceMap() {
        return this.m_durableParticipantXAResourceMap;
    }

    public Map<Xid, WSATSynchronization> getVolatileParticipantSynchronizationMap() {
        return this.m_volatileParticipantSynchronizationMap;
    }

    public Map<Xid, ParticipantIF<T>> getVolatileParticipantPortMap() {
        return this.m_volatileParticipantPortMap;
    }

    public void debug(String string) {
        debugWSAT.debug(string);
    }

    public static String assignUUID() {
        return UUID.randomUUID().toString();
    }
}

