/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import weblogic.transaction.TransactionHelper;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.WSATHelper;

public class WSATSynchronization
implements Synchronization {
    Xid m_xid;
    String m_status = "UNKNOWN";
    private static final String UNKNOWN = "UNKNOWN";
    boolean m_isRemovedFromMap = false;
    Transactional.Version m_version;
    EndpointReference m_epr;

    public WSATSynchronization(EndpointReference endpointReference, Xid xid) {
        this(Transactional.Version.WSAT10, endpointReference, xid);
    }

    public WSATSynchronization(Transactional.Version version2, EndpointReference endpointReference, Xid xid) {
        this.m_version = version2;
        this.m_xid = xid;
        this.m_epr = endpointReference;
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWSATSynchronization((String)this.m_epr.toString(), (Object)this.m_xid, (String)"");
        }
    }

    public void setStatus(String string) {
        this.m_status = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logBeforeCompletionEntered((String)this.m_epr.toString(), (Object)this.m_xid);
        }
        try {
            WSATHelper.getInstance().beforeCompletion(this.m_epr, this.m_xid, this);
            WSATSynchronization wSATSynchronization = this;
            synchronized (wSATSynchronization) {
                block17: {
                    if (!this.m_status.equals("Committed")) break block17;
                    if (WSATHelper.isDebugEnabled()) {
                        WseeWsatLogger.logBeforeCompletionCommittedBeforeWait((String)this.m_epr.toString(), (Object)this.m_xid);
                    }
                    return;
                }
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logBeforeCompletionWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                }
                this.wait(WSATHelper.getInstance().getWaitForReplyTimeout());
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logBeforeCompletionFinishedWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                }
            }
            WseeWsatLogger.logBeforeCompletionReceivedReplyWithStatus((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
            if (!this.m_status.equals("Committed")) {
                WseeWsatLogger.logBeforeCompletionUnexceptedStatus((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                this.setRollbackOnly();
            }
        }
        catch (InterruptedException interruptedException) {
            WseeWsatLogger.logBeforeCompletionInterruptedException((Exception)interruptedException, (String)this.m_epr.toString(), (Object)this.m_xid);
            this.setRollbackOnly();
        }
        catch (Exception exception) {
            WseeWsatLogger.logBeforeCompletionException((Exception)exception, (String)this.m_epr.toString(), (Object)this.m_xid);
            this.setRollbackOnly();
        }
        finally {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
            this.m_isRemovedFromMap = true;
        }
    }

    private void setRollbackOnly() {
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
        if (transaction != null) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException systemException) {
                WseeWsatLogger.logBeforeCompletionSystemExceptionDuringSetRollbackOnly((Exception)((Object)systemException), (String)this.m_epr.toString(), (Object)this.m_xid);
            }
        } else {
            WseeWsatLogger.logBeforeCompletionTransactionNullDuringSetRollbackOnly((String)this.m_epr.toString(), (Object)this.m_xid);
        }
    }

    public void afterCompletion(int n) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logAfterCompletionStatus((String)this.m_epr.toString(), (Object)this.m_xid, (String)("" + n));
        }
    }

    Xid getXid() {
        return this.m_xid;
    }

    public boolean equals(Object object) {
        return object instanceof WSATSynchronization && ((WSATSynchronization)object).getXid().equals(this.m_xid);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
        }
    }
}

